/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandAspect;
import org.glassfish.api.admin.CommandAspectFacade;
import org.glassfish.api.admin.CommandAspectImpl;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.WrappedAdminCommand;
import org.glassfish.hk2.api.ServiceLocator;

public final class CommandSupport {
    public static String getParamValue(AdminCommand command, String name) {
        return CommandSupport.getParamValue(command, name, String.class);
    }

    public static <T> T getParamValue(AdminCommand command, String name, Class<T> paramType) {
        AdminCommand unwrappedCommand = CommandSupport.getUnwrappedCommand(command);
        Class<?> commandClass = unwrappedCommand.getClass();
        for (final Field field : commandClass.getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param == null || !name.equals(CommandModel.getParamName(param, field))) continue;
            if (!paramType.isAssignableFrom(field.getType())) break;
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                Object value = field.get(unwrappedCommand);
                return paramType.cast(value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unexpected error", e);
            }
        }
        return null;
    }

    public static void init(ServiceLocator serviceLocator, AdminCommand command, final AdminCommandContext context, final Job instance) {
        CommandSupport.processAspects(serviceLocator, command, new Function(){

            @Override
            public AdminCommand apply(Annotation a, CommandAspectImpl<Annotation> aspect, AdminCommand command) {
                aspect.init(a, command, context, instance);
                return command;
            }
        });
    }

    public static void done(ServiceLocator serviceLocator, AdminCommand command, final Job instance, boolean isNotify) {
        CommandAspectFacade commandAspectFacade;
        CommandSupport.processAspects(serviceLocator, command, new Function(){

            @Override
            public AdminCommand apply(Annotation a, CommandAspectImpl<Annotation> aspect, AdminCommand command) {
                aspect.done(a, command, instance);
                return command;
            }
        });
        if (isNotify && (commandAspectFacade = serviceLocator.getService(CommandAspectFacade.class, new Annotation[0])) != null) {
            commandAspectFacade.done(command, instance);
        }
    }

    public static void done(ServiceLocator serviceLocator, AdminCommand command, Job instance) {
        CommandSupport.done(serviceLocator, command, instance, false);
    }

    public static AdminCommand createWrappers(ServiceLocator serviceLocator, final CommandModel model, AdminCommand command, final ActionReport report) {
        return CommandSupport.processAspects(serviceLocator, command, new Function(){

            @Override
            public AdminCommand apply(Annotation a, CommandAspectImpl<Annotation> cai, AdminCommand command) {
                return cai.createWrapper(a, model, command, report);
            }
        });
    }

    private static AdminCommand processAspects(ServiceLocator serviceLocator, AdminCommand command, Function function) {
        Annotation[] annotations;
        for (Annotation a : annotations = CommandSupport.getUnwrappedCommand(command).getClass().getAnnotations()) {
            CommandAspect ca = a.annotationType().getAnnotation(CommandAspect.class);
            if (ca == null) continue;
            CommandAspectImpl cai = (CommandAspectImpl)serviceLocator.getService((Type)ca.value(), new Annotation[0]);
            command = function.apply(a, cai, command);
        }
        return command;
    }

    private static AdminCommand getUnwrappedCommand(AdminCommand wrappedCommand) {
        if (wrappedCommand instanceof WrappedAdminCommand) {
            return ((WrappedAdminCommand)wrappedCommand).getWrappedCommand();
        }
        return wrappedCommand;
    }

    private static interface Function {
        public AdminCommand apply(Annotation var1, CommandAspectImpl<Annotation> var2, AdminCommand var3);
    }
}

