/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class BeanValidationHelper
extends Enum<BeanValidationHelper> {
    public static final /* enum */ BeanValidationHelper BEAN_VALIDATION_HELPER = new BeanValidationHelper();
    private static final int DEFAULT_CONSTRAINTS_QUANTITY = 25;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int KNOWN_CONSTRAINTS_DEFAULT_SIZE;
    private static final Set<String> KNOWN_CONSTRAINTS;
    private static final Map<Class<?>, Boolean> CONSTRAINTS_ON_CLASSES;
    private static final /* synthetic */ BeanValidationHelper[] ENUM$VALUES;

    static {
        ENUM$VALUES = new BeanValidationHelper[]{BEAN_VALIDATION_HELPER};
        KNOWN_CONSTRAINTS_DEFAULT_SIZE = BeanValidationHelper.nextPowerOfTwo(33);
        KNOWN_CONSTRAINTS = Collections.newSetFromMap(new ConcurrentHashMap(KNOWN_CONSTRAINTS_DEFAULT_SIZE, 0.75f));
        CONSTRAINTS_ON_CLASSES = Collections.synchronizedMap(new WeakHashMap());
        BeanValidationHelper.initializeKnownConstraints();
    }

    public boolean isConstrained(Class<?> clazz) {
        Boolean annotated = CONSTRAINTS_ON_CLASSES.get(clazz);
        if (annotated == null) {
            annotated = this.detectConstraints(clazz);
            CONSTRAINTS_ON_CLASSES.put(clazz, annotated);
        }
        return annotated;
    }

    private Boolean detectConstraints(Class<?> clazz) {
        Class<? extends Annotation> classAnnotationType;
        Annotation typesClassAnnotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        String typeCanonicalName;
        Class<? extends Annotation> type2;
        Annotation a;
        int n3;
        int n4;
        Annotation[] annotationArray2;
        AccessibleObject[] accessibleObjectArray = this.getDeclaredFields(clazz);
        int n5 = accessibleObjectArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Field f = accessibleObjectArray[n6];
            annotationArray2 = f.getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type2 = a.annotationType();
                typeCanonicalName = type2.getCanonicalName();
                if (KNOWN_CONSTRAINTS.contains(typeCanonicalName)) {
                    return true;
                }
                annotationArray = type2.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if ("javax.validation.Constraint".equals(classAnnotationType.getCanonicalName())) {
                        if (typeCanonicalName != null) {
                            KNOWN_CONSTRAINTS.add(typeCanonicalName);
                        }
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        accessibleObjectArray = this.getDeclaredMethods(clazz);
        n5 = accessibleObjectArray.length;
        n6 = 0;
        while (n6 < n5) {
            AccessibleObject m = accessibleObjectArray[n6];
            annotationArray2 = ((Method)m).getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type2 = a.annotationType();
                typeCanonicalName = type2.getCanonicalName();
                if (KNOWN_CONSTRAINTS.contains(typeCanonicalName)) {
                    return true;
                }
                annotationArray = type2.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if ("javax.validation.Constraint".equals(classAnnotationType.getCanonicalName())) {
                        if (typeCanonicalName != null) {
                            KNOWN_CONSTRAINTS.add(typeCanonicalName);
                        }
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        return false;
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        }) : PrivilegedAccessHelper.getDeclaredMethods(clazz);
    }

    private Field[] getDeclaredFields(final Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        }) : PrivilegedAccessHelper.getDeclaredFields(clazz);
    }

    private static void initializeKnownConstraints() {
        KNOWN_CONSTRAINTS.add("javax.validation.Valid");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Max");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Min");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMax");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMin");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Digits");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.NotNull");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Pattern");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Size");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertTrue");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertFalse");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Future");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Past");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Max");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Min");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.DecimalMax");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.DecimalMin");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Digits");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.NotNull");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Pattern");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Size");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.AssertTrue");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.AssertFalse");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Future");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Past");
    }

    private static int nextPowerOfTwo(int x) {
        assert (x > 0);
        x = x-- | x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static BeanValidationHelper[] values() {
        BeanValidationHelper[] beanValidationHelperArray = ENUM$VALUES;
        int n = beanValidationHelperArray.length;
        BeanValidationHelper[] beanValidationHelperArray2 = new BeanValidationHelper[n];
        System.arraycopy(ENUM$VALUES, 0, beanValidationHelperArray2, 0, n);
        return beanValidationHelperArray2;
    }

    public static BeanValidationHelper valueOf(String string) {
        return Enum.valueOf(BeanValidationHelper.class, string);
    }
}

