/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionLocker;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.BaseSessionLocker;
import org.apache.catalina.session.StandardSession;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class ManagerBase
implements Manager {
    protected static final Logger log = StandardServer.log;
    protected static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Exception initializing random number generator of class {0}", level="SEVERE", cause="Could not construct and seed a new random number generator", action="Verify if the current random number generator class is ")
    public static final String INIT_RANDOM_NUMBER_GENERATOR_EXCEPTION = "AS-WEB-CORE-00351";
    @LogMessageInfo(message="Seeding random number generator class {0}", level="FINE")
    public static final String SEEDING_RANDOM_NUMBER_GENERATOR_CLASS = "AS-WEB-CORE-00352";
    @LogMessageInfo(message="Failed to close randomIS.", level="WARNING")
    public static final String FAILED_CLOSE_RANDOMIS_EXCEPTION = "AS-WEB-CORE-00353";
    @LogMessageInfo(message="Error registering ", level="SEVERE", cause="Could not construct an object name", action="Verify the format of domain, path, host. And make sure they are no null")
    public static final String ERROR_REGISTERING_EXCEPTION = "AS-WEB-CORE-00354";
    @LogMessageInfo(message="setAttribute: Non-serializable attribute with name {0}", level="WARNING")
    public static final String NON_SERIALIZABLE_ATTRIBUTE_EXCEPTION = "AS-WEB-CORE-00355";
    @LogMessageInfo(message="Session not found {0}", level="INFO")
    public static final String SESSION_NOT_FOUND = "AS-WEB-CORE-00356";
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected Container container;
    protected int debug = 0;
    protected boolean distributable;
    protected String entropy = null;
    protected SessionLocker sessionLocker = new BaseSessionLocker();
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 16;
    protected static final String name = "ManagerBase";
    private Random random = null;
    protected UuidGenerator uuidGenerator = new UuidGeneratorImpl();
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected int expiredSessions = 0;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected int sessionCounter = 0;
    protected volatile int maxActive = 0;
    protected final Object maxActiveUpdateLock = new Object();
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int rejectedSessions = 0;
    protected String domain;
    protected ObjectName oname;

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator aUuidGenerator) {
        this.uuidGenerator = aUuidGenerator;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.getMaxInactiveIntervalSeconds();
    }

    @Override
    public int getMaxInactiveIntervalSeconds() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.setMaxInactiveIntervalSeconds(interval);
    }

    @Override
    public void setMaxInactiveIntervalSeconds(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    @Override
    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomFile(String s) {
        if (Globals.IS_SECURITY_ENABLED) {
            this.randomIS = AccessController.doPrivileged(new PrivilegedSetRandomFile());
        } else {
            FileInputStream fileInputStream = null;
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                fileInputStream = new FileInputStream(f);
                this.randomIS = new DataInputStream(fileInputStream);
                this.randomIS.readLong();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Opening " + this.devRandomSource);
                }
            }
            catch (IOException ex) {
                this.randomIS = null;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    public synchronized Random getRandom() {
        if (this.random == null) {
            long seed;
            long t1 = seed = System.currentTimeMillis();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (byte)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                String msg = MessageFormat.format(rb.getString(INIT_RANDOM_NUMBER_GENERATOR_EXCEPTION), this.randomClass);
                log.log(Level.SEVERE, msg, e);
                this.random = new Random();
                this.random.setSeed(seed);
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 100L && log.isLoggable(Level.FINE)) {
                String msg = MessageFormat.format(rb.getString(SEEDING_RANDOM_NUMBER_GENERATOR_CLASS), this.randomClass);
                log.log(Level.FINE, msg + " " + (t2 - t1));
            }
        }
        return this.random;
    }

    protected synchronized void resetRandom() {
        this.random = null;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    @Override
    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    @Override
    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public void setSessionLocker(SessionLocker sessLocker) {
        this.sessionLocker = sessLocker;
    }

    public void destroy() {
        if (this.randomIS != null) {
            block3: {
                try {
                    this.randomIS.close();
                }
                catch (IOException ioe) {
                    if (!log.isLoggable(Level.WARNING)) break block3;
                    log.log(Level.WARNING, FAILED_CLOSE_RANDOMIS_EXCEPTION);
                }
            }
            this.randomIS = null;
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                this.domain = ctx.getEngineName();
                this.distributable = ctx.getDistributable();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getEncodedPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, ERROR_REGISTERING_EXCEPTION, e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Registering " + this.oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Session createSession() {
        Session session = null;
        session = this.createEmptySession();
        session.lockForeground();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId(session);
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    @Override
    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.lockForeground();
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public void checkSessionAttribute(String name, Object value) {
        if (this.getDistributable() && !StandardSession.isSerializable(value)) {
            String msg = MessageFormat.format(rb.getString(NON_SERIALIZABLE_ATTRIBUTE_EXCEPTION), name);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session findSession(String id, HttpServletRequest request) throws IOException {
        return this.findSession(id);
    }

    @Override
    public Session findSession(String id, String version) throws IOException {
        return this.findSession(id);
    }

    @Override
    public boolean isSessionVersioningSupported() {
        return false;
    }

    public void clearSessions() {
        this.sessions.clear();
    }

    @Override
    public Session[] findSessions() {
        Collection<Session> sessionsValues = this.sessions.values();
        ArrayList<Session> list = new ArrayList<Session>(sessionsValues.size());
        for (Session session : sessionsValues) {
            list.add(session);
        }
        return list.toArray(new Session[list.size()]);
    }

    @Override
    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    @Override
    public Cookie toCookie(Session session) throws IOException {
        return null;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void changeSessionId(Session session) {
        session.setId(this.generateSessionId());
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Got " + len + " " + bytes.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.devRandomSource = null;
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId(Object obj) {
        return this.uuidGenerator.generateUuid(obj);
    }

    protected synchronized String generateSessionId() {
        return this.generateSessionId(new Object());
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    protected void log(String message) {
        log.log(Level.INFO, message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.INFO, message, throwable);
    }

    @Override
    public void setSessionCounter(int sessionCounter) {
        this.setSessionCount(sessionCounter);
    }

    @Override
    public void setSessionCount(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    @Override
    public int getSessionCounter() {
        return this.getSessionCount();
    }

    @Override
    public int getSessionCount() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.getSessionMaxAliveTimeSeconds();
    }

    @Override
    public int getSessionMaxAliveTimeSeconds() {
        return this.sessionMaxAliveTime;
    }

    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.setSessionMaxAliveTimeSeconds(sessionMaxAliveTime);
    }

    @Override
    public void setSessionMaxAliveTimeSeconds(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    @Override
    public int getSessionAverageAliveTime() {
        return this.getSessionAverageAliveTimeSeconds();
    }

    @Override
    public int getSessionAverageAliveTimeSeconds() {
        return this.sessionAverageAliveTime;
    }

    @Override
    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.setSessionAverageAliveTimeSeconds(sessionAverageAliveTime);
    }

    @Override
    public void setSessionAverageAliveTimeSeconds(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, SESSION_NOT_FOUND, sessionId);
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, SESSION_NOT_FOUND, sessionId);
            }
            return;
        }
        s.expire();
    }

    public String getLastAccessedTimeMillis(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, SESSION_NOT_FOUND, sessionId);
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    @Override
    public void update(HttpSession session) throws Exception {
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    @Override
    public void preRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    @Override
    public boolean lockSession(ServletRequest request) throws ServletException {
        boolean result = false;
        if (this.sessionLocker != null) {
            result = this.sessionLocker.lockSession(request);
        }
        return result;
    }

    @Override
    public void unlockSession(ServletRequest request) {
        if (this.sessionLocker != null) {
            this.sessionLocker.unlockSession(request);
        }
    }

    public void release() {
        this.clearSessions();
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction<DataInputStream> {
        private PrivilegedSetRandomFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataInputStream run() {
            DataInputStream dataInputStream;
            FileInputStream fileInputStream = null;
            try {
                File f = new File(ManagerBase.this.devRandomSource);
                if (!f.exists()) {
                    DataInputStream dataInputStream2 = null;
                    return dataInputStream2;
                }
                fileInputStream = new FileInputStream(f);
                ManagerBase.this.randomIS = new DataInputStream(fileInputStream);
                ManagerBase.this.randomIS.readLong();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Opening " + ManagerBase.this.devRandomSource);
                }
                dataInputStream = ManagerBase.this.randomIS;
            }
            catch (IOException ex) {
                DataInputStream dataInputStream3 = null;
                return dataInputStream3;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return dataInputStream;
        }
    }
}

