/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardServer;

public class SingleSignOnEntry {
    private static final Logger log = StandardServer.log;
    protected final String id;
    protected final String authType;
    protected Principal principal;
    protected final Map<String, Session> sessions = new HashMap<String, Session>();
    protected final String username;
    protected final String realmName;
    protected long lastAccessTime;
    protected final AtomicLong version;

    public SingleSignOnEntry(String id, long ver, Principal principal, String authType, String username, String realmName) {
        this.id = id;
        this.version = new AtomicLong(ver);
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.realmName = realmName;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        Session oldEntry = this.sessions.put(session.getId(), session);
        if (oldEntry == null) {
            session.addSessionListener(sso);
        }
        return oldEntry == null;
    }

    public synchronized void removeSession(Session session) {
        Session removed = this.sessions.remove(session.getId());
        log.warning("session " + session.getId() + "found (and removed): " + removed);
    }

    public synchronized boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    public synchronized void expireSessions() {
        for (Session session : this.sessions.values()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " Invalidating session " + session);
            }
            if (!session.getIsValid()) continue;
            session.expire();
        }
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version.get();
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long incrementAndGetVersion() {
        return this.version.incrementAndGet();
    }
}

