/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.appserv.ProxyHandler;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.connector.MapperListener;
import com.sun.enterprise.web.connector.coyote.PECoyoteResponse;
import com.sun.enterprise.web.connector.extension.GrizzlyConfig;
import com.sun.enterprise.web.connector.grizzly.DummyConnectorLauncher;
import com.sun.enterprise.web.pwc.connector.coyote.PwcCoyoteRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.Connector;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.common.CipherInfo;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.util.IntrospectionUtils;

public class PECoyoteConnector
extends Connector {
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final String DUMMY_CONNECTOR_LAUNCHER = DummyConnectorLauncher.class.getName();
    protected static final Logger _logger = WebContainer.logger;
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    @LogMessageInfo(message="Invalid max-pending-count attribute value [{0}], using default [{1}]", level="WARNING")
    public static final String INVALID_MAX_PENDING_COUNT = "AS-WEB-GLUE-00067";
    @LogMessageInfo(message="Unable to parse proxy port component ({0}) of server-name attribute of network-listener {1}", level="SEVERE", cause="The String does not contain a parsable integer", action="Check the proxy port string")
    public static final String INVALID_PROXY_PORT = "AS-WEB-GLUE-00068";
    @LogMessageInfo(message="Unable to parse redirect-port ({0}) attribute of network-listener {1}, using default: {2}", level="WARNING")
    public static final String INVALID_REDIRECT_PORT = "AS-WEB-GLUE-00069";
    @LogMessageInfo(message="Unable to parse acceptor-threads attribute ({0}) of network-listener {1}, using default: {2}", level="WARNING")
    public static final String INVALID_ACCEPTOR_THREADS = "AS-WEB-GLUE-00070";
    @LogMessageInfo(message="The jk properties configuration file is not defined", level="FINEST")
    public static final String JK_PROPERTIES_NOT_DEFINED = "AS-WEB-GLUE-00071";
    @LogMessageInfo(message="JK properties file {0} does not exist", level="WARNING")
    public static final String MISSING_JK_PROPERTIES = "AS-WEB-GLUE-00072";
    @LogMessageInfo(message="Loading glassfish-jk.properties from {0}", level="FINEST")
    public static final String LOADING_JK_PROPERTIED = "AS-WEB-GLUE-00073";
    @LogMessageInfo(message="Unable to configure JK properties {0} for connector listening to {1}", level="SEVERE", cause="Failed to load JK properties file", action="Check if the properties file exists and is readable")
    public static final String UNABLE_TO_CONFIGURE_JK = "AS-WEB-GLUE-00074";
    @LogMessageInfo(message="Invalid attribute [{0}] in thread-pool configuration", level="WARNING")
    public static final String INVALID_THREAD_POOL_ATTRIBUTE = "AS-WEB-GLUE-00075";
    @LogMessageInfo(message="Unable to load ProxyHandler implementation class {0}", level="SEVERE", cause="An exception occurred during creating a new instance ", action="Check the exception for the error")
    public static final String PROXY_HANDLER_CLASS_LOAD_ERROR = "AS-WEB-GLUE-00076";
    @LogMessageInfo(message="{0} not an instance of com.sun.appserv.ProxyHandler", level="SEVERE", cause="Invalid proxy handler", action="Check to see if the proxy handler is an instance of com.sun.appserv.ProxyHandler")
    public static final String PROXY_HANDLER_CLASS_INVALID = "AS-WEB-GLUE-00077";
    @LogMessageInfo(message="All SSL protocol variants disabled for network-listener {0}, using SSL implementation specific defaults", level="WARNING")
    public static final String ALL_SSL_PROTOCOLS_DISABLED = "AS-WEB-GLUE-00078";
    @LogMessageInfo(message="All SSL cipher suites disabled for network-listener(s) {0}. Using SSL implementation specific defaults", level="FINE")
    public static final String ALL_CIPHERS_DISABLED = "AS-WEB-GLUE-00079";
    @LogMessageInfo(message="Unrecognized cipher: {0}", level="WARNING")
    public static final String UNRECOGNIZED_CIPHER = "AS-WEB-GLUE-00080";
    protected boolean recycleObjects;
    protected int maxAcceptWorkerThreads;
    protected int maxReadWorkerThreads;
    protected int processorWorkerThreadsTimeout;
    protected int minAcceptQueueLength;
    protected int minReadQueueLength;
    protected int minProcessorQueueLength;
    protected boolean useDirectByteBuffer;
    private int keepAliveTimeoutInSeconds;
    private int keepAliveThreadCount;
    private int queueSizeInBytes = 4096;
    protected int ssBackLog = 4096;
    private int selectorReadThreadsCount = 0;
    protected GrizzlyConfig grizzlyMonitor;
    private String rootFolder = "";
    protected MapperListener mapperListener;
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = 2048L;
    private long maxEntrySize = 537600L;
    private long maxLargeFileCacheSize = 0xA00000L;
    private long maxSmallFileCacheSize = 0x100000L;
    private boolean fileCacheEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private String crlFile;
    private String trustAlgorithm;
    private String trustMaxCertLength;
    private WebContainer webContainer;
    private RequestProbeProvider requestProbeProvider;

    public PECoyoteConnector(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.requestProbeProvider = webContainer.getRequestProbeProvider();
        this.setProtocolHandlerClassName(DUMMY_CONNECTOR_LAUNCHER);
    }

    @Override
    public Request createRequest() {
        PwcCoyoteRequest request = new PwcCoyoteRequest();
        request.setConnector(this);
        return request;
    }

    @Override
    public Response createResponse() {
        PECoyoteResponse response = new PECoyoteResponse();
        response.setConnector(this);
        return response;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.setProperty("keepAliveTimeoutInSeconds", String.valueOf(timeout));
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setKeepAliveThreadCount(int number) {
        this.keepAliveThreadCount = number;
        this.setProperty("KeepAliveThreadCount", String.valueOf(number));
    }

    public void setQueueSizeInBytes(int queueSizeInBytes) {
        this.queueSizeInBytes = queueSizeInBytes;
        this.setProperty("queueSizeInBytes", String.valueOf(queueSizeInBytes));
    }

    public int getQueueSizeInBytes() {
        return this.queueSizeInBytes;
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
        this.setProperty("socketServerBacklog", String.valueOf(ssBackLog));
    }

    public int getSocketServerBacklog() {
        return this.ssBackLog;
    }

    public void setRecycleObjects(boolean recycleObjects) {
        this.recycleObjects = recycleObjects;
        this.setProperty("recycleObjects", String.valueOf(recycleObjects));
    }

    public boolean getRecycleObjects() {
        return this.recycleObjects;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
        this.setProperty("maxReadWorkerThreads", String.valueOf(maxReadWorkerThreads));
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public void setMaxAcceptWorkerThreads(int maxAcceptWorkerThreads) {
        this.maxAcceptWorkerThreads = maxAcceptWorkerThreads;
        this.setProperty("maxAcceptWorkerThreads", String.valueOf(maxAcceptWorkerThreads));
    }

    public int getMaxAcceptWorkerThreads() {
        return this.maxAcceptWorkerThreads;
    }

    public void setMinAcceptQueueLength(int minAcceptQueueLength) {
        this.minAcceptQueueLength = minAcceptQueueLength;
        this.setProperty("minAcceptQueueLength", String.valueOf(minAcceptQueueLength));
    }

    public int getMinAcceptQueueLength() {
        return this.minAcceptQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
        this.setProperty("minReadQueueLength", String.valueOf(minReadQueueLength));
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
        this.setProperty("minProcessorQueueLength", String.valueOf(minProcessorQueueLength));
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.setProperty("useDirectByteBuffer", String.valueOf(useDirectByteBuffer));
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.processorWorkerThreadsTimeout = timeout;
        this.setProperty("processorWorkerThreadsTimeout", String.valueOf(timeout));
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.processorWorkerThreadsTimeout;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.selectorReadThreadsCount = selectorReadThreadsCount;
        this.setProperty("selectorReadThreadsCount", String.valueOf(selectorReadThreadsCount));
    }

    public int getSelectorReadThreadsCount() {
        return this.selectorReadThreadsCount;
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
        if (this.domain != null) {
            if (!"admin-listener".equals(this.getName())) {
                this.mapper.removeContext(this.getDefaultHost(), "");
                this.mapper.removeHost(this.getDefaultHost());
            }
            this.mapperListener.setDomain(this.domain);
            this.mapperListener.setNetworkListenerName(this.getName());
            this.mapperListener.setDefaultHost(this.getDefaultHost());
            this.mapperListener.setInstanceName(this.getInstanceName());
            this.mapperListener.init();
            this.getService().getBroadcaster().addNotificationListener(this.mapperListener, this.mapperListener, null);
            Notification notification = new Notification("chloe", this.getObjectName(), 0L);
            this.getService().getBroadcaster().sendNotification(notification);
        }
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.initConfig();
            this.grizzlyMonitor.registerMonitoringLevelEvents();
        }
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.destroy();
            this.grizzlyMonitor = null;
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
        this.setProperty("secondsMaxAge", String.valueOf(this.secondsMaxAge));
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
        this.setProperty("maxCacheEntries", String.valueOf(this.maxCacheEntries));
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
        this.setProperty("minEntrySize", String.valueOf(this.minEntrySize));
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
        this.setProperty("maxEntrySize", String.valueOf(this.maxEntrySize));
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
        this.setProperty("maxLargeFileCacheSize", String.valueOf(this.maxLargeFileCacheSize));
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
        this.setProperty("maxSmallFileCacheSize", String.valueOf(this.maxSmallFileCacheSize));
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.fileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
        this.setProperty("fileCacheEnabled", String.valueOf(fileCacheEnabled));
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
        this.setProperty("largeFileCacheEnabled", String.valueOf(this.isLargeFileCacheEnabled));
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        this.rootFolder = rootFolder;
        this.setProperty("webAppRootPath", rootFolder);
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    @Override
    public void initialize() throws LifecycleException {
        super.initialize();
        this.mapperListener = new MapperListener(this.mapper, this.webContainer);
        this.grizzlyMonitor = new GrizzlyConfig(this.webContainer, this.domain, this.getPort());
    }

    public void setTruststore(String truststore) {
        this.setProperty("truststore", truststore);
    }

    public String getTruststore() {
        return this.getProperty("truststore");
    }

    public void setTruststoreType(String type2) {
        this.setProperty("truststoreType", type2);
    }

    public String getTruststoreType() {
        return this.getProperty("truststoreType");
    }

    public void setKeystoreType(String type2) {
        this.setProperty("keystoreType", type2);
    }

    public String getKeystoreType() {
        return this.getProperty("keystoreType");
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
        this.setProperty("crlFile", crlFile);
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String trustAlgorithm) {
        this.trustAlgorithm = trustAlgorithm;
        this.setProperty("truststoreAlgorithm", trustAlgorithm);
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
        this.setProperty("trustMaxCertLength", trustMaxCertLength);
    }

    public MapperListener getMapperListener() {
        return this.mapperListener;
    }

    public void configure(NetworkListener listener, boolean isSecure, HttpService httpService) {
        String redirectPort;
        Transport transport = listener.findTransport();
        try {
            this.setSocketServerBacklog(Integer.parseInt(transport.getMaxConnectionsCount()));
        }
        catch (NumberFormatException ex) {
            String msg = MessageFormat.format(_rb.getString(INVALID_MAX_PENDING_COUNT), transport.getMaxConnectionsCount(), Integer.toString(this.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        this.setDomain(this.webContainer.getServerContext().getDefaultDomainName());
        this.configureSSL(listener);
        this.configureThreadPool(listener.findThreadPool());
        Http http = listener.findHttpProtocol().getHttp();
        this.configureFileCache(http.getFileCache());
        this.setMaxHttpHeaderSize(Integer.parseInt(http.getSendBufferSizeBytes()));
        this.setDefaultHost(http.getDefaultVirtualServer());
        this.setEnableLookups(ConfigBeansUtilities.toBoolean(http.getDnsLookupEnabled()));
        this.setXpoweredBy(Boolean.valueOf(http.getXpoweredBy()));
        this.setWebAppRootPath(this.webContainer.getModulesRoot().getAbsolutePath());
        String serverName = http.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                this.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        this.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, INVALID_PROXY_PORT, new Object[]{serverPort, listener.getName()});
                    }
                }
            } else {
                this.setProxyName(serverName);
            }
        }
        if ((redirectPort = http.getRedirectPort()) != null && redirectPort.length() != 0) {
            try {
                this.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, INVALID_REDIRECT_PORT, new Object[]{redirectPort, listener.getName(), Integer.toString(this.getRedirectPort())});
            }
        } else {
            this.setRedirectPort(-1);
        }
        String acceptorThreads = transport.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                this.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, INVALID_ACCEPTOR_THREADS, new Object[]{acceptorThreads, listener.getName(), Integer.toString(this.getMaxProcessors())});
            }
        }
        if (isSecure) {
            this.configureKeysAndCerts();
        }
        this.webContainer.configureHttpServiceProperties(httpService, this);
        this.configureHttpListenerProperties(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJKProperties(NetworkListener listener) {
        File propertiesFile = null;
        if (listener != null) {
            propertiesFile = new File(listener.getJkConfigurationFile());
        }
        String propertyFile = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
        if (propertiesFile != null && !propertiesFile.exists() && propertyFile != null) {
            propertiesFile = new File(propertyFile);
        }
        if (propertiesFile == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, JK_PROPERTIES_NOT_DEFINED);
            }
            return;
        }
        if (!propertiesFile.exists()) {
            _logger.log(Level.WARNING, MessageFormat.format(_rb.getString("pewebcontainer.missingJKProperties"), propertiesFile.getAbsolutePath()));
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, MessageFormat.format(_rb.getString(LOADING_JK_PROPERTIED), propertiesFile.getAbsolutePath()));
        }
        Properties properties = null;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(propertiesFile));
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(_rb.getString(UNABLE_TO_CONFIGURE_JK), propertiesFile, this.getPort());
            _logger.log(Level.SEVERE, msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            String value = properties.getProperty(propName);
            if (value == null) continue;
            IntrospectionUtils.setProperty(this, propName, value);
        }
    }

    public void configureFileCache(FileCache fileCache) {
        if (fileCache != null) {
            this.setLargeFileCacheEnabled(ConfigBeansUtilities.toBoolean(fileCache.getEnabled()));
            if (fileCache.getMaxAgeSeconds() != null) {
                this.setSecondsMaxAge(Integer.parseInt(fileCache.getMaxAgeSeconds()));
            }
            if (fileCache.getMaxFilesCount() != null) {
                this.setMaxCacheEntries(Integer.parseInt(fileCache.getMaxFilesCount()));
            }
            if (fileCache.getMaxCacheSizeBytes() != null) {
                this.setMaxLargeCacheSize(Integer.parseInt(fileCache.getMaxCacheSizeBytes()));
            }
        }
    }

    public void configureThreadPool(ThreadPool pool) {
        if (pool != null) {
            String msg;
            try {
                this.setMaxProcessors(Integer.parseInt(pool.getMaxThreadPoolSize()));
            }
            catch (NumberFormatException ex) {
                msg = MessageFormat.format(_rb.getString(INVALID_THREAD_POOL_ATTRIBUTE), "max-thread-pool-size");
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                this.setMinProcessors(Integer.parseInt(pool.getMinThreadPoolSize()));
            }
            catch (NumberFormatException ex) {
                msg = MessageFormat.format(_rb.getString(INVALID_THREAD_POOL_ATTRIBUTE), "min-thread-pool-size");
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                this.setQueueSizeInBytes(Integer.parseInt(pool.getMaxQueueSize()));
            }
            catch (NumberFormatException ex) {
                msg = MessageFormat.format(_rb.getString(INVALID_THREAD_POOL_ATTRIBUTE), "max-queue-size");
                _logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    public boolean configureHttpListenerProperty(String propName, String propValue) throws NumberFormatException {
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(propValue);
            return true;
        }
        return false;
    }

    public void configHttpProperties(Http http, Transport transport, Ssl ssl) {
        this.setAllowTrace(ConfigBeansUtilities.toBoolean(http.getTraceEnabled()));
        this.setMaxKeepAliveRequests(Integer.parseInt(http.getMaxConnections()));
        this.setKeepAliveTimeoutInSeconds(Integer.parseInt(http.getTimeoutSeconds()));
        this.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean(http.getAuthPassThroughEnabled()));
        this.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        this.setMaxSavePostSize(Integer.parseInt(http.getMaxSavePostSizeBytes()));
        this.setProperty("compression", http.getCompression());
        this.setProperty("compressableMimeType", http.getCompressableMimeType());
        if (http.getNoCompressionUserAgents() != null) {
            this.setProperty("noCompressionUserAgents", http.getNoCompressionUserAgents());
        }
        this.setProperty("compressionMinSize", http.getCompressionMinSizeBytes());
        if (http.getRestrictedUserAgents() != null) {
            this.setProperty("restrictedUserAgents", http.getRestrictedUserAgents());
        }
        this.setProperty("cometSupport", Boolean.valueOf(ConfigBeansUtilities.toBoolean(http.getCometSupportEnabled())).toString());
        this.setProperty("rcmSupport", Boolean.valueOf(ConfigBeansUtilities.toBoolean(http.getRcmSupportEnabled())).toString());
        this.setConnectionUploadTimeout(Integer.parseInt(http.getConnectionUploadTimeoutMillis()));
        this.setDisableUploadTimeout(!ConfigBeansUtilities.toBoolean(http.getUploadTimeoutEnabled()));
        this.setURIEncoding(http.getUriEncoding());
        this.configSslOptions(ssl);
    }

    private void configSslOptions(Ssl ssl) {
        if (ssl != null) {
            if (ssl.getCrlFile() != null) {
                this.setCrlFile(ssl.getCrlFile());
            }
            if (ssl.getTrustAlgorithm() != null) {
                this.setTrustAlgorithm(ssl.getTrustAlgorithm());
            }
            if (ssl.getTrustMaxCertLength() != null) {
                this.setTrustMaxCertLength(ssl.getTrustMaxCertLength());
            }
        }
    }

    public void setProxyHandler(String className) {
        Object handler = null;
        try {
            Class handlerClass = this.webContainer.loadCommonClass(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = MessageFormat.format(_rb.getString(PROXY_HANDLER_CLASS_LOAD_ERROR), className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, PROXY_HANDLER_CLASS_INVALID, className);
            } else {
                this.setProxyHandler((ProxyHandler)handler);
            }
        }
    }

    @Override
    public void requestStartEvent(HttpServletRequest request, Host host, Context context) {
        if (this.requestProbeProvider != null) {
            String appName = null;
            if (context instanceof WebModule) {
                appName = ((WebModule)context).getMonitoringNodeName();
            }
            String hostName = null;
            if (host != null) {
                hostName = host.getName();
            }
            this.requestProbeProvider.requestStartEvent(appName, hostName, request.getServerName(), request.getServerPort(), request.getContextPath(), request.getServletPath());
        }
    }

    @Override
    public void requestEndEvent(HttpServletRequest request, Host host, Context context, int statusCode) {
        if (this.requestProbeProvider != null) {
            String appName = null;
            if (context instanceof WebModule) {
                appName = ((WebModule)context).getMonitoringNodeName();
            }
            String hostName = null;
            if (host != null) {
                hostName = host.getName();
            }
            this.requestProbeProvider.requestEndEvent(appName, hostName, request.getServerName(), request.getServerPort(), request.getContextPath(), request.getServletPath(), statusCode, request.getMethod(), request.getRequestURI());
        }
    }

    private void configureSSL(NetworkListener listener) {
        String ciphers;
        Ssl sslConfig = listener.findHttpProtocol().getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.valueOf(sslConfig.getClientAuthEnabled()).booleanValue()) {
            this.setClientAuth(true);
        }
        StringBuilder sslProtocolsBuf = new StringBuilder();
        boolean needComma = false;
        if (Boolean.valueOf(sslConfig.getSsl2Enabled()).booleanValue()) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue() || Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, ALL_SSL_PROTOCOLS_DISABLED, listener.getName());
        } else {
            this.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            this.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, ALL_CIPHERS_DISABLED, listener.getName());
                }
            } else {
                this.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeysAndCerts() {
        String prop = System.getProperty("javax.net.ssl.keyStore");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        if (prop != null) {
            this.setKeystoreFile(prop);
            this.setKeystoreType(keyStoreType);
        }
        if ((prop = System.getProperty("javax.net.ssl.trustStore")) != null) {
            this.setTruststore(prop);
            this.setTruststoreType("JKS");
        }
    }

    private void configureHttpListenerProperties(NetworkListener listener) {
        this.configHttpProperties(listener.findHttpProtocol().getHttp(), listener.findTransport(), listener.findHttpProtocol().getSsl());
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuilder enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, UNRECOGNIZED_CIPHER, cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuilder();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, UNRECOGNIZED_CIPHER, cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuilder();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }
}

