/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.GenericHandler;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.jsp.JSPCompiler;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    private static final Logger logger = WebContainer.logger;
    private static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Unable to load configuration of web module [{0}]", level="WARNING")
    public static final String UNABLE_TO_LOAD_CONFIG = "AS-WEB-GLUE-00220";
    @LogMessageInfo(message="Failed to precompile JSP pages of web module [{0}]", level="SEVERE", cause="An exception occurred precompiling JSP pages", action="Check the exception for the error")
    public static final String JSPC_FAILED = "AS-WEB-GLUE-00221";
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    RequestDispatcher dispatcher;

    @Override
    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{WebBundleDescriptorImpl.class}, new Class[]{Application.class});
    }

    @Override
    public <V> V loadMetaData(Class<V> type2, DeploymentContext dc) {
        WebBundleDescriptorImpl wbd = dc.getModuleMetaData(WebBundleDescriptorImpl.class);
        if (wbd.isStandalone()) {
            DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
            String contextRoot = params.contextroot;
            if (contextRoot == null && "".equals(contextRoot = wbd.getContextRoot())) {
                contextRoot = null;
            }
            if (contextRoot == null) {
                contextRoot = params.previousContextRoot;
            }
            if (contextRoot == null) {
                contextRoot = ((GenericHandler)dc.getArchiveHandler()).getDefaultApplicationNameFromArchiveName(dc.getOriginalSource());
            }
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            wbd.setContextRoot(contextRoot);
            wbd.setName(params.name());
            dc.getAppProps().setProperty("context-root", contextRoot);
        }
        return null;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        try {
            DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
            wmInfo.setDescriptor(dc.getModuleMetaData(WebBundleDescriptorImpl.class));
            wmInfo.setVirtualServers(params.virtualservers);
            wmInfo.setLocation(dc.getSourceDir());
            wmInfo.setObjectType(dc.getAppProps().getProperty("object-type"));
        }
        catch (Exception ex) {
            String msg = rb.getString(UNABLE_TO_LOAD_CONFIG);
            msg = MessageFormat.format(msg, wmInfo.getName());
            logger.log(Level.WARNING, msg, ex);
        }
        return wmInfo;
    }

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        if (params.precompilejsp.booleanValue()) {
            this.runJSPC(dc);
        }
    }

    @Override
    public WebApplication load(WebContainer container, DeploymentContext dc) {
        super.load(container, dc);
        WebBundleDescriptorImpl wbd = dc.getModuleMetaData(WebBundleDescriptorImpl.class);
        if (wbd != null) {
            wbd.setClassLoader(dc.getClassLoader());
        }
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        WebApplication webApp = new WebApplication(container, wmInfo, new ApplicationConfigInfo(dc.getAppProps()));
        return webApp;
    }

    @Override
    public void unload(WebApplication webApplication, DeploymentContext dc) {
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptorImpl wbd = dc.getModuleMetaData(WebBundleDescriptorImpl.class);
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            StringBuilder classpath = new StringBuilder(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            classpath.append(ASClassLoaderUtil.getModuleClassPath(this.sc.getDefaultServices(), wbd.getApplication().getName(), dc.getCommandParameters(DeployCommandParameters.class).libraries));
            JSPCompiler.compile(inDir, outDir, (WebBundleDescriptor)wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            String msg = rb.getString(JSPC_FAILED);
            msg = MessageFormat.format(msg, wbd.getApplication().getName());
            logger.log(Level.SEVERE, msg, de);
            throw de;
        }
    }
}

