/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class ThreadPoolMonitor
implements ThreadPoolProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public ThreadPoolMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, ThreadPoolConfig config) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null) {
            ConnectionQueueStatsProvider connectionQueueStatsProvider;
            ThreadPoolStatsProvider threadPoolStatsProvider = grizzlyMonitoring.getThreadPoolStatsProvider(monitoringId);
            if (threadPoolStatsProvider != null) {
                threadPoolStatsProvider.setStatsObject(config);
                threadPoolStatsProvider.reset();
            }
            if ((connectionQueueStatsProvider = grizzlyMonitoring.getConnectionQueueStatsProvider(monitoringId)) != null) {
                connectionQueueStatsProvider.setStatsObject(config);
                connectionQueueStatsProvider.reset();
            }
        }
    }

    @Override
    public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
    }

    @Override
    public void onThreadPoolStopEvent(AbstractThreadPool threadPool) {
    }

    @Override
    public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadAllocatedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), thread.getId());
    }

    @Override
    public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReleasedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), thread.getId());
    }

    @Override
    public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().maxNumberOfThreadsReachedEvent(this.monitoringId, threadPool.getConfig().getPoolName(), maxNumberOfThreads);
    }

    @Override
    public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId());
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(this.monitoringId, task.getClass().getName());
    }

    @Override
    public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId());
    }

    @Override
    public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, threadPool.getConfig().getPoolName(), Thread.currentThread().getId());
    }

    @Override
    public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(this.monitoringId, task.getClass().getName());
    }

    @Override
    public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
        this.grizzlyMonitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(this.monitoringId);
    }
}

