/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AppLibClassLoaderServiceImpl {
    @Inject
    ServiceLocator habitat;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    private Map<URI, DelegatingClassLoader.ClassFinder> classFinderRegistry = new HashMap<URI, DelegatingClassLoader.ClassFinder>();

    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        ClassLoaderHierarchy clh = this.habitat.getService(ClassLoaderHierarchy.class, new Annotation[0]);
        DelegatingClassLoader connectorCL = clh.getConnectorClassLoader(application);
        if (libURIs == null || libURIs.isEmpty()) {
            return connectorCL;
        }
        final ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        DelegatingClassLoader applibCL = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

            @Override
            public DelegatingClassLoader run() {
                return new DelegatingClassLoader(commonCL);
            }
        });
        for (DelegatingClassLoader.ClassFinder cf : connectorCL.getDelegates()) {
            applibCL.addDelegate(cf);
        }
        this.addDelegates(libURIs, applibCL);
        return applibCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelegates(Collection<URI> libURIs, DelegatingClassLoader holder) throws MalformedURLException {
        ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        for (URI libURI : libURIs) {
            AppLibClassLoaderServiceImpl appLibClassLoaderServiceImpl = this;
            synchronized (appLibClassLoaderServiceImpl) {
                DelegatingClassLoader.ClassFinder libCF = this.classFinderRegistry.get(libURI);
                if (libCF == null) {
                    libCF = new URLClassFinder(new URL[]{libURI.toURL()}, commonCL);
                    this.classFinderRegistry.put(libURI, libCF);
                }
                holder.addDelegate(libCF);
            }
        }
    }

    public DelegatingClassLoader.ClassFinder getAppLibClassFinder(Collection<URI> libURIs) throws MalformedURLException {
        final ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        DelegatingClassLoader appLibClassFinder = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

            @Override
            public DelegatingClassLoader run() {
                return new AppLibClassFinder(commonCL);
            }
        });
        this.addDelegates(libURIs, appLibClassFinder);
        return (DelegatingClassLoader.ClassFinder)((Object)appLibClassFinder);
    }

    private static class AppLibClassFinder
    extends DelegatingClassLoader
    implements DelegatingClassLoader.ClassFinder {
        public AppLibClassFinder(ClassLoader parent, List<DelegatingClassLoader.ClassFinder> delegates) throws IllegalArgumentException {
            super(parent, delegates);
        }

        public AppLibClassFinder(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> findExistingClass(String name) {
            return null;
        }

        @Override
        public URL findResource(String name) {
            return super.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return super.findResources(name);
        }
    }

    private static class URLClassFinder
    extends URLClassLoader
    implements DelegatingClassLoader.ClassFinder {
        public URLClassFinder(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return super.findClass(name);
        }

        @Override
        public Class<?> findExistingClass(String name) {
            return super.findLoadedClass(name);
        }
    }
}

