/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.JVMInformationCollector;
import com.sun.enterprise.v3.admin.commands.StringBuilderNewLineAppender;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class MemoryReporter {
    private final MBeanServerConnection mbsc;
    private RuntimeMXBean rmbean;
    private MemoryMXBean mmbean;
    private List<MemoryPoolMXBean> pools;
    private List<GarbageCollectorMXBean> gcmbeans;
    private static final StringManager sm = StringManager.getManager(MemoryReporter.class);

    public MemoryReporter(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public String getMemoryReport() {
        this.init();
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(this.getMemoryPoolReport());
        sb.append(this.getGarbageCollectionReport());
        sb.append(this.getMemoryMXBeanReport());
        return sb.toString();
    }

    private void init() throws RuntimeException {
        try {
            ObjectName objName;
            Iterator<ObjectName> iterator;
            this.rmbean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
            this.mmbean = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Memory", MemoryMXBean.class);
            ObjectName poolName = new ObjectName("java.lang:type=MemoryPool,*");
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            Set<ObjectName> mbeans = this.mbsc.queryNames(poolName, null);
            if (mbeans != null) {
                this.pools = new ArrayList<MemoryPoolMXBean>();
                iterator = mbeans.iterator();
                MemoryPoolMXBean p = null;
                while (iterator.hasNext()) {
                    objName = iterator.next();
                    p = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, objName.getCanonicalName(), MemoryPoolMXBean.class);
                    this.pools.add(p);
                }
            }
            if ((mbeans = this.mbsc.queryNames(gcName, null)) != null) {
                this.gcmbeans = new ArrayList<GarbageCollectorMXBean>();
                iterator = mbeans.iterator();
                GarbageCollectorMXBean gc = null;
                while (iterator.hasNext()) {
                    objName = iterator.next();
                    gc = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, objName.getCanonicalName(), GarbageCollectorMXBean.class);
                    this.gcmbeans.add(gc);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getMemoryPoolReport() {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        long millis = this.rmbean.getUptime();
        String uptime = sm.getString("uptime", JVMInformationCollector.millis2HoursMinutesSeconds(millis));
        sb.append(uptime);
        for (MemoryPoolMXBean m : this.pools) {
            String n = m.getName();
            sb.append(sm.getString("memory.pool.name", n));
            MemoryUsage mu = m.getUsage();
            sb.append(this.mu2String(mu));
        }
        return sb.toString();
    }

    private String mu2String(MemoryUsage mu) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        String init = JVMInformationCollector.formatLong(mu.getInit());
        sb.append(sm.getString("memory.usage.init", init));
        String comm = JVMInformationCollector.formatLong(mu.getCommitted());
        sb.append(sm.getString("memory.usage.comm", comm));
        String max = JVMInformationCollector.formatLong(mu.getMax());
        sb.append(sm.getString("memory.usage.max", max));
        String used = JVMInformationCollector.formatLong(mu.getUsed());
        sb.append(sm.getString("memory.usage.used", used));
        return sb.toString();
    }

    private String getGarbageCollectionReport() {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        for (GarbageCollectorMXBean m : this.gcmbeans) {
            String name = sm.getString("gc.name", m.getName());
            sb.append(name);
            String cc = sm.getString("gc.numcol", JVMInformationCollector.formatLong(m.getCollectionCount()));
            sb.append(cc);
            String gct = sm.getString("gc.coltime", JVMInformationCollector.millis2SecondsMillis(m.getCollectionTime()));
            sb.append(gct);
        }
        return sb.toString();
    }

    private String getMemoryMXBeanReport() {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(sm.getString("heap.mem.usage"));
        sb.append(this.mu2String(this.mmbean.getHeapMemoryUsage()));
        sb.append(sm.getString("nonheap.mem.usage"));
        sb.append(this.mu2String(this.mmbean.getNonHeapMemoryUsage()));
        sb.append(sm.getString("obj.fin.pending", this.mmbean.getObjectPendingFinalizationCount()));
        return sb.toString();
    }
}

