/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.admin.RestartServer;
import com.sun.enterprise.v3.admin.cluster.Strings;
import javax.inject.Inject;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_restart-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@Async
@I18n(value="restart.instance.command")
@ExecuteOn(value={RuntimeType.INSTANCE})
public class RestartInstanceInstanceCommand
extends RestartServer
implements AdminCommand {
    @Inject
    ModulesRegistry registry;
    @Inject
    private ServerEnvironment env;
    @Param(name="debug", optional=true)
    private Boolean debug;

    @Override
    public void execute(AdminCommandContext context) {
        if (!this.env.isInstance()) {
            String msg = Strings.get("restart.instance.notInstance", this.env.getRuntimeType().toString());
            context.getLogger().warning(msg);
            return;
        }
        this.setRegistry(this.registry);
        this.setServerName(this.env.getInstanceName());
        if (this.debug != null) {
            this.setDebug(this.debug);
        }
        this.doExecute(context);
    }
}

