/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.SecurityContextProxy;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.PrincipalImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SecurityContext
extends AbstractSecurityContext {
    private static Logger _logger = null;
    private static InheritableThreadLocal<SecurityContext> currentSecCtx;
    private static SecurityContext defaultSecurityContext;
    private static AuthPermission doAsPrivilegedPerm;
    private boolean SERVER_GENERATED_SECURITY_CONTEXT = false;

    public SecurityContext(String userName, Subject subject) {
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("NCLS-SECURITY-05052");
            }
        }
        this.initiator = new PrincipalImpl(userName);
        final Subject sub = s;
        this.subject = (Subject)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(SecurityContext.this.initiator);
                return sub;
            }
        });
    }

    public SecurityContext(Subject subject) {
        if (subject == null) {
            subject = new Subject();
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("NCLS-SECURITY-05052");
            }
        }
        final Subject fsub = subject;
        this.subject = subject;
        this.initiator = (Principal)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator<Principal> prinIter;
                Principal prin = null;
                for (Object obj : fsub.getPublicCredentials()) {
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    DistinguishedPrincipalCredential dpc = (DistinguishedPrincipalCredential)obj;
                    prin = dpc.getPrincipal();
                    break;
                }
                if (prin == null && (prinIter = fsub.getPrincipals().iterator()).hasNext()) {
                    prin = prinIter.next();
                }
                return prin;
            }
        });
        this.postConstruct();
    }

    private void initDefaultCallerPrincipal() {
        if (this.initiator == null) {
            this.initiator = SecurityContext.getDefaultCallerPrincipal();
        }
    }

    public SecurityContext(String userName, Subject subject, String realm) {
        PrincipalGroupFactory factory;
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("NCLS-SECURITY-05052");
            }
        }
        if ((factory = Globals.getDefaultHabitat().getService(PrincipalGroupFactory.class, new Annotation[0])) != null) {
            this.initiator = factory.getPrincipalInstance(userName, realm);
        }
        final Subject sub = s;
        this.subject = (Subject)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sub.getPrincipals().add(SecurityContext.this.initiator);
                return sub;
            }
        });
    }

    public SecurityContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Default CTOR of SecurityContext called");
        }
        this.subject = new Subject();
        this.initiator = null;
        this.setServerGeneratedCredentials();
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext.this.subject.setReadOnly();
                return null;
            }
        });
    }

    public static SecurityContext init() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static SecurityContext getDefaultSecurityContext() {
        return defaultSecurityContext;
    }

    public static Subject getDefaultSubject() {
        return SecurityContext.defaultSecurityContext.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal getDefaultCallerPrincipal() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            if (SecurityContext.defaultSecurityContext.initiator == null) {
                String guestUser = null;
                try {
                    guestUser = (String)AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            SecurityService securityService = SecurityServicesUtil.getInstance().getHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
                            if (securityService == null) {
                                return null;
                            }
                            return securityService.getDefaultPrincipal();
                        }
                    });
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "NCLS-SECURITY-05038", e);
                }
                finally {
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
                SecurityContext.defaultSecurityContext.initiator = new PrincipalImpl(guestUser);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SecurityContext.defaultSecurityContext.initiator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityContext generateDefaultSecurityContext() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return (SecurityContext)AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new SecurityContext();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-SECURITY-05036", e);
                // ** MonitorExit[var0] (shouldn't be in output)
            }
            return null;
        }
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static SecurityContext getCurrent() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static void setCurrent(SecurityContext sc) {
        if (sc != null && sc != defaultSecurityContext) {
            SecurityContext current = (SecurityContext)currentSecCtx.get();
            if (sc != current) {
                boolean permitted = false;
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("permission check done to set SecurityContext");
                        }
                        sm.checkPermission(doAsPrivilegedPerm);
                    }
                    permitted = true;
                }
                catch (SecurityException se) {
                    _logger.log(Level.SEVERE, "NCLS-SECURITY-05048", se);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "NCLS-SECURITY-05049", t);
                }
                if (permitted) {
                    currentSecCtx.set(sc);
                } else {
                    _logger.severe("NCLS-SECURITY-05050");
                }
            }
        } else {
            currentSecCtx.set(sc);
        }
    }

    public static void setUnauthenticatedContext() {
        currentSecCtx.set(defaultSecurityContext);
    }

    public boolean didServerGenerateCredentials() {
        return this.SERVER_GENERATED_SECURITY_CONTEXT;
    }

    private void setServerGeneratedCredentials() {
        this.SERVER_GENERATED_SECURITY_CONTEXT = true;
    }

    @Override
    public Principal getCallerPrincipal() {
        return this == defaultSecurityContext ? SecurityContext.getDefaultCallerPrincipal() : this.initiator;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext[ Initiator: " + this.initiator + "Subject " + this.subject + " ]";
    }

    public Set getPrincipalSet() {
        return this.subject.getPrincipals();
    }

    public void postConstruct() {
        this.initDefaultCallerPrincipal();
    }

    @Override
    public AppServSecurityContext newInstance(String userName, Subject subject, String realm) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityContext: newInstance method called");
        }
        return new SecurityContext(userName, subject, realm);
    }

    @Override
    public AppServSecurityContext newInstance(String userName, Subject subject) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityContext: newInstance method called");
        }
        return new SecurityContext(userName, subject);
    }

    @Override
    public void setCurrentSecurityContext(AppServSecurityContext context) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityContext: setCurrentSecurityContext method called");
        }
        if (context == null) {
            SecurityContext.setCurrent(null);
            return;
        }
        if (context instanceof SecurityContext) {
            SecurityContext.setCurrent((SecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected SecurityContext, found " + context);
    }

    @Override
    public AppServSecurityContext getCurrentSecurityContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityContext: getCurrent() method called");
        }
        return SecurityContext.getCurrent();
    }

    @Override
    public void setUnauthenticatedSecurityContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SecurityContext: setUnauthenticatedSecurityContext method called");
        }
        SecurityContext.setUnauthenticatedContext();
    }

    @Override
    public void setSecurityContextWithPrincipal(Principal principal) {
        SecurityContext ctx = this.getSecurityContextForPrincipal(principal);
        SecurityContext.setCurrent(ctx);
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal p) {
        if (p == null) {
            return null;
        }
        if (p instanceof SecurityContextProxy) {
            return ((SecurityContextProxy)((Object)p)).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject s = new Subject();
                s.getPrincipals().add(p);
                return new SecurityContext(p.getName(), s);
            }
        });
    }

    static {
        _logger = SecurityLoggerInfo.getLogger();
        currentSecCtx = new InheritableThreadLocal();
        defaultSecurityContext = SecurityContext.generateDefaultSecurityContext();
        doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    }
}

