/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Singleton
public class PoolMonitoringLevelListener
implements PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    private Domain domain;
    private ModuleMonitoringLevels monitoringLevel;
    private boolean jdbcPoolMonitoringEnabled;
    private boolean connectorPoolMonitoringEnabled;
    private static final Logger _logger = LogDomains.getLogger(PoolMonitoringLevelListener.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public void postConstruct() {
        ModuleMonitoringLevels monitoringLevel;
        MonitoringService monitoringService;
        String instanceName = this.serverEnvironment.getInstanceName();
        Server server = this.domain.getServerNamed(instanceName);
        Config config = server.getConfig();
        if (config != null && (monitoringService = config.getMonitoringService()) != null && (monitoringLevel = monitoringService.getModuleMonitoringLevels()) != null) {
            this.monitoringLevel = monitoringLevel;
            ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(monitoringLevel));
            bean.addListener(this);
            this.jdbcPoolMonitoringEnabled = !monitoringLevel.getJdbcConnectionPool().equalsIgnoreCase("OFF");
            this.connectorPoolMonitoringEnabled = !monitoringLevel.getConnectorConnectionPool().equalsIgnoreCase("OFF");
        }
    }

    @Override
    public void preDestroy() {
        if (this.monitoringLevel != null) {
            ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.monitoringLevel));
            bean.removeListener(this);
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new PropertyChangeHandler(events), _logger);
    }

    public boolean getJdbcPoolMonitoringEnabled() {
        return this.jdbcPoolMonitoringEnabled;
    }

    public boolean getConnectorPoolMonitoringEnabled() {
        return this.connectorPoolMonitoringEnabled;
    }

    class PropertyChangeHandler
    implements Changed {
        private PropertyChangeHandler(PropertyChangeEvent[] events) {
        }

        @Override
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            switch (type2) {
                case CHANGE: {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                    }
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            if (instance instanceof ModuleMonitoringLevels) {
                ModuleMonitoringLevels mml = (ModuleMonitoringLevels)instance;
                PoolMonitoringLevelListener.this.connectorPoolMonitoringEnabled = !mml.getConnectorConnectionPool().equalsIgnoreCase("OFF");
                PoolMonitoringLevelListener.this.jdbcPoolMonitoringEnabled = !mml.getJdbcConnectionPool().equalsIgnoreCase("OFF");
            }
            return np;
        }
    }
}

