/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.DynamicallyReconfigurableResource;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.RetryableUnavailableException;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;

public class DynamicResourceReconfigurator
implements InvocationHandler,
DynamicallyReconfigurableResource {
    private Object actualObject;
    private ResourceInfo resourceInfo;
    private boolean invalid = false;
    private long resourceInfoVersion = 0L;
    protected static final Logger _logger = LogDomains.getLogger(DynamicResourceReconfigurator.class, "javax.enterprise.resource.resourceadapter");

    public DynamicResourceReconfigurator(Object actualObject, ResourceInfo resourceInfo) {
        this.actualObject = actualObject;
        this.resourceInfo = resourceInfo;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.invalid) {
            throw new ResourceException("Resource [" + this.resourceInfo + "] instance is not valid any more");
        }
        if (method.getName().equals("setDelegate") && args.length == 1) {
            this.setDelegate(args[0]);
        } else if (method.getName().equals("setInvalid") && args.length == 0) {
            this.setInvalid();
        } else {
            long version = ConnectorRegistry.getInstance().getResourceInfoVersion(this.resourceInfo);
            if (version == -1L) {
                this.setInvalid();
                this.invoke(proxy, method, args);
            }
            boolean status = this.resourceInfoVersion >= version;
            this.resourceInfoVersion = version;
            if (!status) {
                this.debug("status is outdated: " + this);
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("com.sun.enterprise.resource.reconfig.proxyCall", "TRUE");
                ResourceNamingService namingService = ConnectorRuntime.getRuntime().getResourceNamingService();
                this.actualObject = namingService.lookup(this.resourceInfo, this.resourceInfo.getName(), env);
                this.debug("actualObject : " + this.actualObject);
            } else {
                this.debug("status is true: " + this);
            }
            this.debug("DynamicResourceReconfigurator : method : " + method.getName());
            try {
                return method.invoke(this.actualObject, args);
            }
            catch (InvocationTargetException ite) {
                this.debug("exception [ " + ite + " ] in method : " + method.getName());
                if (ite.getCause() != null && ite.getCause().getCause() != null) {
                    return this.retryIfNeeded(proxy, method, args, ite.getCause().getCause());
                }
                if (ite.getCause() != null) {
                    return this.retryIfNeeded(proxy, method, args, ite.getCause());
                }
                throw ite;
            }
        }
        return null;
    }

    private Object retryIfNeeded(Object proxy, Method method, Object[] args, Throwable actualException) throws Throwable {
        RetryableUnavailableException rue;
        if (actualException instanceof RetryableUnavailableException && "POOL-RECONFIGURED-1".equals((rue = (RetryableUnavailableException)actualException).getErrorCode())) {
            this.debug(" DynamicResourceReconfigurator : retryable-exception in method, retrying : " + method.getName());
            return this.invoke(proxy, method, args);
        }
        throw actualException;
    }

    @Override
    public void setDelegate(Object o) {
        this.actualObject = o;
    }

    @Override
    public void setInvalid() {
        this.invalid = true;
    }

    private void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[DRC] : " + message);
        }
    }
}

