/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=JMSConnectionFactoryDefinitionDescriptor.class)
public class JMSConnectionFactoryDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private static Logger _logger = LogDomains.getLogger(JMSConnectionFactoryDefinitionDeployer.class, "javax.enterprise.resource.resourceadapter");
    static final String PROPERTY_PREFIX = "org.glassfish.connector-connection-pool.";

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        JMSConnectionFactoryDefinitionDescriptor desc = (JMSConnectionFactoryDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), JavaEEResourceType.JMSCFDDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JMSConnectionFactoryDefinitionDeployer.deployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJMSConnectionFactoryConnectionPool connectorCp = new MyJMSConnectionFactoryConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).deployResource(connectorCp);
        MyJMSConnectionFactoryResource connectorResource = new MyJMSConnectionFactoryResource(poolName, resourceName);
        this.getDeployer(connectorResource).deployResource(connectorResource);
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private JMSConnectionFactoryProperty convertProperty(String name, String value) {
        return new JMSConnectionFactoryProperty(name, value);
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        JMSConnectionFactoryDefinitionDescriptor desc = (JMSConnectionFactoryDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), JavaEEResourceType.JMSCFDDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JMSConnectionFactoryDefinitionDeployer.undeployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyJMSConnectionFactoryResource connectorResource = new MyJMSConnectionFactoryResource(poolName, resourceName);
        this.getDeployer(connectorResource).undeployResource(connectorResource);
        MyJMSConnectionFactoryConnectionPool connectorCp = new MyJMSConnectionFactoryConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).undeployResource(connectorCp);
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for jms-connection-factory-definition type");
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for jms-connection-factory-definition type");
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for jms-connection-factory-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof JMSConnectionFactoryDefinitionDescriptor;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    private boolean isValidProperty(String s) {
        return s != null && !s.equals("");
    }

    class MyJMSConnectionFactoryConnectionPool
    extends FakeConfigBean
    implements ConnectorConnectionPool {
        private JMSConnectionFactoryDefinitionDescriptor desc;
        private String name;

        public MyJMSConnectionFactoryConnectionPool(JMSConnectionFactoryDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getObjectType() {
            return "user";
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name;
        }

        @Override
        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            if (minPoolSize >= 0) {
                return String.valueOf(minPoolSize);
            }
            return "8";
        }

        @Override
        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            if (maxPoolSize >= 0) {
                return String.valueOf(maxPoolSize);
            }
            return "32";
        }

        @Override
        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxWaitTimeInMillis() {
            String maxWaitTimeInMillis = this.desc.getProperty("org.glassfish.connector-connection-pool.max-wait-time-in-millis");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(maxWaitTimeInMillis)) {
                return maxWaitTimeInMillis;
            }
            return "60000";
        }

        @Override
        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        @Override
        public String getPoolResizeQuantity() {
            String poolResizeQuantity = this.desc.getProperty("org.glassfish.connector-connection-pool.pool-resize-quantity");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(poolResizeQuantity)) {
                return poolResizeQuantity;
            }
            return "2";
        }

        @Override
        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdleTimeoutInSeconds() {
            String idleTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.idle-timeout-in-seconds");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(idleTimeoutInSeconds)) {
                return idleTimeoutInSeconds;
            }
            return "300";
        }

        @Override
        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsConnectionValidationRequired() {
            String isConnectionValidationRequired = this.desc.getProperty("org.glassfish.connector-connection-pool.is-connection-validation-required");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(isConnectionValidationRequired)) {
                return isConnectionValidationRequired;
            }
            return "false";
        }

        @Override
        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        @Override
        public String getResourceAdapterName() {
            String resourceAdapter = this.desc.getResourceAdapter();
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(resourceAdapter)) {
                return resourceAdapter;
            }
            return "jmsra";
        }

        @Override
        public void setResourceAdapterName(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionDefinitionName() {
            String interfaceName = this.desc.getInterfaceName();
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(interfaceName)) {
                return interfaceName;
            }
            return "javax.jms.ConnectionFactory";
        }

        @Override
        public void setConnectionDefinitionName(String value) throws PropertyVetoException {
        }

        @Override
        public String getFailAllConnections() {
            String failAllConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.fail-all-connections");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(failAllConnections)) {
                return failAllConnections;
            }
            return "false";
        }

        @Override
        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransactionSupport() {
            String transactionSupport = this.desc.getProperty("org.glassfish.connector-connection-pool.transaction-support");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(transactionSupport)) {
                return transactionSupport;
            }
            return "NoTransaction";
        }

        @Override
        public void setTransactionSupport(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidateAtmostOncePeriodInSeconds() {
            String validateAtmostOncePeriodInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.validate-at-most-once-period-in-seconds");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(validateAtmostOncePeriodInSeconds)) {
                return validateAtmostOncePeriodInSeconds;
            }
            return "0";
        }

        @Override
        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakTimeoutInSeconds() {
            String connectionLeakTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-timeout-in-seconds");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(connectionLeakTimeoutInSeconds)) {
                return connectionLeakTimeoutInSeconds;
            }
            return "0";
        }

        @Override
        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakReclaim() {
            String connectionLeakReclaim = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-reclaim");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(connectionLeakReclaim)) {
                return connectionLeakReclaim;
            }
            return "0";
        }

        @Override
        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryAttempts() {
            String connectionCreationRetryAttempts = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-attempts");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(connectionCreationRetryAttempts)) {
                return connectionCreationRetryAttempts;
            }
            return "0";
        }

        @Override
        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryIntervalInSeconds() {
            String connectionCreationRetryIntervalInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-interval-in-seconds");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(connectionCreationRetryIntervalInSeconds)) {
                return connectionCreationRetryIntervalInSeconds;
            }
            return "0";
        }

        @Override
        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionEnlistment() {
            String lazyConnectionEnlistment = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-enlistment");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(lazyConnectionEnlistment)) {
                return lazyConnectionEnlistment;
            }
            return "false";
        }

        @Override
        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionAssociation() {
            String lazyConnectionAssociation = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-association");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(lazyConnectionAssociation)) {
                return lazyConnectionAssociation;
            }
            return "false";
        }

        @Override
        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        @Override
        public String getAssociateWithThread() {
            String associateWithThread = this.desc.getProperty("org.glassfish.connector-connection-pool.associate-with-thread");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(associateWithThread)) {
                return associateWithThread;
            }
            return "false";
        }

        @Override
        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        @Override
        public String getPooling() {
            String pooling = this.desc.getProperty("org.glassfish.connector-connection-pool.pooling");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(pooling)) {
                return pooling;
            }
            return "true";
        }

        @Override
        public void setPooling(String value) throws PropertyVetoException {
        }

        @Override
        public String getMatchConnections() {
            String matchConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.match-connections");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(matchConnections)) {
                return matchConnections;
            }
            return "true";
        }

        @Override
        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxConnectionUsageCount() {
            String maxConnectionUsageCount = this.desc.getProperty("org.glassfish.connector-connection-pool.max-connection-usage-count");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(maxConnectionUsageCount)) {
                return maxConnectionUsageCount;
            }
            return "0";
        }

        @Override
        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            JMSConnectionFactoryProperty property;
            Properties p = this.desc.getProperties();
            ArrayList<Property> jmsConnectionFactoryProperties = new ArrayList<Property>();
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getUser())) {
                property = JMSConnectionFactoryDefinitionDeployer.this.convertProperty("UserName", this.desc.getUser());
                jmsConnectionFactoryProperties.add(property);
            }
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getPassword())) {
                property = JMSConnectionFactoryDefinitionDeployer.this.convertProperty("Password", this.desc.getPassword());
                jmsConnectionFactoryProperties.add(property);
            }
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getClientId())) {
                property = JMSConnectionFactoryDefinitionDeployer.this.convertProperty("clientId", this.desc.getClientId());
                jmsConnectionFactoryProperties.add(property);
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(JMSConnectionFactoryDefinitionDeployer.PROPERTY_PREFIX) || key.equalsIgnoreCase("UserName") && JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getUser()) || key.equalsIgnoreCase("Password") && JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getPassword()) || key.equalsIgnoreCase("clientId") && JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(this.desc.getClientId())) continue;
                String value = (String)entry.getValue();
                JMSConnectionFactoryProperty property2 = JMSConnectionFactoryDefinitionDeployer.this.convertProperty(key, value);
                jmsConnectionFactoryProperties.add(property2);
            }
            return jmsConnectionFactoryProperties;
        }

        @Override
        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new JMSConnectionFactoryProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
        }

        @Override
        public String getPing() {
            String ping = this.desc.getProperty("org.glassfish.connector-connection-pool.ping");
            if (JMSConnectionFactoryDefinitionDeployer.this.isValidProperty(ping)) {
                return ping;
            }
            return "false";
        }

        @Override
        public void setPing(String value) throws PropertyVetoException {
        }

        @Override
        public List<SecurityMap> getSecurityMap() {
            return new ArrayList<SecurityMap>(0);
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }

    class MyJMSConnectionFactoryResource
    extends FakeConfigBean
    implements ConnectorResource {
        private String poolName;
        private String jndiName;

        MyJMSConnectionFactoryResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        @Override
        public String getPoolName() {
            return this.poolName;
        }

        @Override
        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.jndiName;
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getJndiName() {
            return this.jndiName;
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }

    class JMSConnectionFactoryProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        JMSConnectionFactoryProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

