/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.MulticastTester;
import com.sun.enterprise.gms.tools.StringManager;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiCastReceiverThread
extends Thread {
    static final StringManager sm = StringManager.getInstance();
    final AtomicBoolean receivedAnything = new AtomicBoolean(false);
    volatile boolean done = false;
    int mcPort;
    String mcAddress;
    boolean debug;
    String targetData;
    MulticastSocket ms;
    String expectedPrefix;

    public MultiCastReceiverThread(int mcPort, String mcAddress, boolean debug, String targetData) {
        super("McastReceiver");
        this.mcPort = mcPort;
        this.mcAddress = mcAddress;
        this.debug = debug;
        this.targetData = targetData;
        StringTokenizer st = new StringTokenizer(targetData, "|");
        this.expectedPrefix = st.nextToken() + "|";
    }

    @Override
    public void run() {
        block6: {
            this.log(String.format("expected message prefix is '%s'", this.expectedPrefix));
            try {
                int bufferSize = 8192;
                InetAddress group2 = InetAddress.getByName(this.mcAddress);
                this.ms = new MulticastSocket(this.mcPort);
                this.ms.joinGroup(group2);
                System.out.println(sm.get("listening.info", new Object[0]));
                HashSet<String> uniqueData = new HashSet<String>();
                while (!this.done) {
                    DatagramPacket dp = new DatagramPacket(new byte[8192], 8192);
                    this.ms.receive(dp);
                    String newData = new String(dp.getData(), Charset.defaultCharset()).trim();
                    this.log(String.format("received '%s'", newData));
                    if (!newData.startsWith(this.expectedPrefix)) {
                        this.log("Ignoring previous data");
                        continue;
                    }
                    if (!uniqueData.add(newData)) continue;
                    if (this.targetData.equals(newData)) {
                        System.out.println(sm.get("loopback.from", MulticastTester.trimDataString(newData)));
                        this.receivedAnything.set(true);
                        continue;
                    }
                    System.out.println(sm.get("received.from", MulticastTester.trimDataString(newData)));
                    this.receivedAnything.set(true);
                }
            }
            catch (SocketException se) {
                this.log("caught socket exception as expected");
            }
            catch (Exception e) {
                System.err.println(sm.get("whoops", e.toString()));
                if (!this.debug) break block6;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        if (this.ms != null) {
            this.log("closing socket in interrupt");
            try {
                this.ms.close();
            }
            catch (Throwable ignored) {
                this.log(ignored.getMessage());
            }
            finally {
                super.interrupt();
            }
        }
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(String.format("%s: %s", this.getName(), msg));
        }
    }
}

