/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.modularity.customization.FileTypeDetails;
import com.sun.enterprise.config.modularity.customization.PortTypeDetails;
import com.sun.enterprise.config.modularity.customization.TokenTypeDetails;
import com.sun.enterprise.util.LocalStringManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ModuleXMLConfigurationFileParser {
    private static final String CONFIG_BUNDLE = "config-bundle";
    private static final String LOCATION = "location";
    private static final String REPLACE_IF_EXISTS = "replace-if-exist";
    private static final String NAME = "name";
    private static final String DEFAULT_VALUE = "default-value";
    private static final String DESCRIPTION = "description";
    private static final String CONFIGURATION_ELEMENT = "configuration-element";
    private static final String CUSTOMIZATION_TOKEN = "customization-token";
    private static final String TITLE = "title";
    private static final String CONFIG_BEAN_CLASS_NAME = "config-bean-class-name";
    private static final String MUST_EXIST = "must-exist";
    private static final String BASE_OFFSET = "base-offset";
    private static final String FILE = "file";
    private static final String PORT = "port";
    private static final String VALIDATION_EXPRESSION = "validation-expression";
    private LocalStringManager localStrings;

    public ModuleXMLConfigurationFileParser(LocalStringManager localStrings) {
        this.localStrings = localStrings;
    }

    public List<ConfigBeanDefaultValue> parseServiceConfiguration(InputStream xmlDocumentStream) throws XMLStreamException {
        ArrayList<ConfigBeanDefaultValue> configBeans = new ArrayList<ConfigBeanDefaultValue>();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLEventReader eventReader = inputFactory.createXMLEventReader(xmlDocumentStream);
        ConfigBeanDefaultValue configValue = null;
        while (eventReader.hasNext()) {
            EndElement endElement;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                Attribute attribute;
                Iterator<Attribute> attributes;
                StartElement startElement = event.asStartElement();
                if (startElement.getName().getLocalPart().equalsIgnoreCase(CONFIG_BUNDLE)) {
                    configValue = new ConfigBeanDefaultValue();
                    attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        attribute = attributes.next();
                        if (attribute.getName().toString().equals(LOCATION)) {
                            configValue.setLocation(attribute.getValue());
                            continue;
                        }
                        if (!attribute.getName().toString().equals(REPLACE_IF_EXISTS)) continue;
                        configValue.setReplaceCurrentIfExists(Boolean.parseBoolean(attribute.getValue()));
                    }
                    continue;
                }
                if (startElement.getName().getLocalPart().equalsIgnoreCase(CUSTOMIZATION_TOKEN)) {
                    String value = null;
                    String description = null;
                    String name = null;
                    String title = null;
                    String validationExpression = null;
                    ConfigCustomizationToken.CustomizationType type2 = ConfigCustomizationToken.CustomizationType.STRING;
                    TokenTypeDetails tokenTypeDetails = null;
                    Iterator<Attribute> attributes2 = startElement.getAttributes();
                    while (attributes2.hasNext()) {
                        Attribute attribute2 = attributes2.next();
                        if (attribute2.getName().toString().equals(DEFAULT_VALUE)) {
                            value = attribute2.getValue();
                            continue;
                        }
                        if (attribute2.getName().toString().equals(DESCRIPTION)) {
                            description = this.getLocalizedValue(attribute2.getValue());
                            continue;
                        }
                        if (attribute2.getName().toString().equals(NAME)) {
                            name = attribute2.getValue();
                            continue;
                        }
                        if (attribute2.getName().toString().equals(TITLE)) {
                            title = this.getLocalizedValue(attribute2.getValue());
                            continue;
                        }
                        if (!attribute2.getName().toString().equals(VALIDATION_EXPRESSION)) continue;
                        validationExpression = this.getLocalizedValue(attribute2.getValue());
                    }
                    event = eventReader.nextEvent();
                    while (!event.isStartElement() && !event.isEndElement()) {
                        event = eventReader.nextEvent();
                    }
                    if (event.isStartElement()) {
                        startElement = event.asStartElement();
                        if (startElement.getName().getLocalPart().equalsIgnoreCase(FILE)) {
                            type2 = ConfigCustomizationToken.CustomizationType.FILE;
                            String tokVal = startElement.getAttributeByName(QName.valueOf(MUST_EXIST)).getValue();
                            FileTypeDetails.FileExistCondition cond = FileTypeDetails.FileExistCondition.NO_OP;
                            if (tokVal.equalsIgnoreCase("true")) {
                                cond = FileTypeDetails.FileExistCondition.MUST_EXIST;
                            } else if (tokVal.equalsIgnoreCase("false")) {
                                cond = FileTypeDetails.FileExistCondition.MUST_NOT_EXIST;
                            }
                            tokenTypeDetails = new FileTypeDetails(cond);
                        } else if (startElement.getName().getLocalPart().equalsIgnoreCase(PORT)) {
                            type2 = ConfigCustomizationToken.CustomizationType.PORT;
                            tokenTypeDetails = new PortTypeDetails(startElement.getAttributeByName(QName.valueOf(BASE_OFFSET)).getValue());
                        }
                    }
                    ConfigCustomizationToken token = new ConfigCustomizationToken(name, title, description, value, validationExpression, tokenTypeDetails, type2);
                    configValue.addCustomizationToken(token);
                    continue;
                }
                if (startElement.getName().getLocalPart().equalsIgnoreCase(CONFIGURATION_ELEMENT)) {
                    attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        attribute = attributes.next();
                        if (!attribute.getName().toString().equals(CONFIG_BEAN_CLASS_NAME)) continue;
                        configValue.setConfigBeanClassName(attribute.getValue());
                    }
                    event = eventReader.nextEvent();
                    if (!event.isCharacters()) continue;
                    String str = event.asCharacters().getData();
                    configValue.setXmlConfiguration(str);
                    continue;
                }
            }
            if (!event.isEndElement() || !(endElement = event.asEndElement()).getName().getLocalPart().equalsIgnoreCase(CONFIG_BUNDLE)) continue;
            configBeans.add(configValue);
        }
        return configBeans;
    }

    private String getLocalizedValue(String value) {
        if (value.startsWith("$")) {
            value = this.localStrings.getLocalString(value.substring(1, value.length()), value.substring(1, value.length()));
        }
        return value;
    }
}

