/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbe;
import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.impl.AccessibleObjectProbe;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.util.counters.Counter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

abstract class MethodProbe {
    final Method method;
    final Probe probe;
    final int type;

    MethodProbe(Method method, Probe probe, int type2) {
        this.method = method;
        this.probe = probe;
        this.type = type2;
        method.setAccessible(true);
    }

    void register(MetricsRegistryImpl metricsRegistry, Object source, String namePrefix) {
        String name = this.getName(namePrefix);
        metricsRegistry.registerInternal(source, name, this);
    }

    private String getName(String namePrefix) {
        String name = this.method.getName();
        if (!this.probe.name().equals("")) {
            name = this.probe.name();
        }
        return namePrefix + "." + name;
    }

    static <S> MethodProbe createMethodProbe(Method method, Probe probe) {
        int type2 = AccessibleObjectProbe.getType(method.getReturnType());
        if (type2 == -1) {
            throw new IllegalArgumentException(String.format("@Probe method '%s.%s() has an unsupported return type'", method.getDeclaringClass().getName(), method.getName()));
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException(String.format("@Probe method '%s.%s' can't have arguments", method.getDeclaringClass().getName(), method.getName()));
        }
        if (AccessibleObjectProbe.isDouble(type2)) {
            return new DoubleMethodProbe(method, probe, type2);
        }
        return new LongMethodProbe(method, probe, type2);
    }

    static class DoubleMethodProbe<S>
    extends MethodProbe
    implements DoubleProbe<S> {
        public DoubleMethodProbe(Method method, Probe probe, int type2) {
            super(method, probe, type2);
        }

        @Override
        public double get(S source) throws Exception {
            switch (this.type) {
                case 3: 
                case 4: {
                    Number result = (Number)this.method.invoke(source, new Object[0]);
                    return result == null ? 0.0 : result.doubleValue();
                }
            }
            throw new IllegalStateException("Unrecognized type:" + this.type);
        }
    }

    static class LongMethodProbe<S>
    extends MethodProbe
    implements LongProbe<S> {
        public LongMethodProbe(Method method, Probe probe, int type2) {
            super(method, probe, type2);
        }

        @Override
        public long get(S source) throws Exception {
            switch (this.type) {
                case 1: {
                    return ((Number)this.method.invoke(source, new Object[0])).longValue();
                }
                case 2: {
                    Number longNumber = (Number)this.method.invoke(source, new Object[0]);
                    return longNumber == null ? 0L : longNumber.longValue();
                }
                case 6: {
                    Map map = (Map)this.method.invoke(source, new Object[0]);
                    return map == null ? 0L : (long)map.size();
                }
                case 5: {
                    Collection collection = (Collection)this.method.invoke(source, new Object[0]);
                    return collection == null ? 0L : (long)collection.size();
                }
                case 7: {
                    Counter counter = (Counter)this.method.invoke(source, new Object[0]);
                    return counter == null ? 0L : counter.get();
                }
            }
            throw new IllegalStateException("Unrecognized type:" + this.type);
        }
    }
}

