/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.internal.ascii.AbstractTextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

public class ErrorCommand
extends AbstractTextCommand {
    ByteBuffer response;
    private final String message;

    public ErrorCommand(TextCommandConstants.TextCommandType type2) {
        this(type2, null);
    }

    public ErrorCommand(TextCommandConstants.TextCommandType type2, String message) {
        super(type2);
        byte[] error = TextCommandConstants.ERROR;
        if (type2 == TextCommandConstants.TextCommandType.ERROR_CLIENT) {
            error = TextCommandConstants.CLIENT_ERROR;
        } else if (type2 == TextCommandConstants.TextCommandType.ERROR_SERVER) {
            error = TextCommandConstants.SERVER_ERROR;
        }
        this.message = message;
        byte[] msg = message == null ? null : StringUtil.stringToBytes(message);
        int total = error.length;
        if (msg != null) {
            total += msg.length;
        }
        this.response = ByteBuffer.allocate(total += 2);
        this.response.put(error);
        if (msg != null) {
            this.response.put(msg);
        }
        this.response.put(TextCommandConstants.RETURN);
        this.response.flip();
    }

    @Override
    public boolean readFrom(ByteBuffer cb) {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "ErrorCommand{type=" + (Object)((Object)this.type) + ", msg=" + this.message + '}' + super.toString();
    }
}

