/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractCacheConfig;
import com.hazelcast.config.CacheConfigReadOnly;
import com.hazelcast.config.CacheEvictionConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;

public class CacheConfig<K, V>
extends AbstractCacheConfig<K, V> {
    private String name;
    private String managerPrefix;
    private String uriString;
    private int asyncBackupCount = 0;
    private int backupCount = 1;
    private InMemoryFormat inMemoryFormat = CacheSimpleConfig.DEFAULT_IN_MEMORY_FORMAT;
    private CacheEvictionConfig evictionConfig = new CacheEvictionConfig();
    private WanReplicationRef wanReplicationRef;

    public CacheConfig() {
    }

    public CacheConfig(String name) {
        this.setName(name);
    }

    public CacheConfig(CompleteConfiguration<K, V> configuration) {
        super(configuration);
        if (configuration instanceof CacheConfig) {
            CacheConfig config = (CacheConfig)configuration;
            this.name = config.name;
            this.managerPrefix = config.managerPrefix;
            this.uriString = config.uriString;
            this.asyncBackupCount = config.asyncBackupCount;
            this.backupCount = config.backupCount;
            this.inMemoryFormat = config.inMemoryFormat;
            if (config.evictionConfig != null) {
                this.evictionConfig = new CacheEvictionConfig(config.evictionConfig);
            }
            if (config.wanReplicationRef != null) {
                this.wanReplicationRef = new WanReplicationRef(config.wanReplicationRef);
            }
        }
    }

    public CacheConfig(CacheSimpleConfig simpleConfig) throws Exception {
        this.name = simpleConfig.getName();
        if (simpleConfig.getKeyType() != null) {
            this.keyType = ClassLoaderUtil.loadClass(null, simpleConfig.getKeyType());
        }
        if (simpleConfig.getValueType() != null) {
            this.valueType = ClassLoaderUtil.loadClass(null, simpleConfig.getValueType());
        }
        this.isStatisticsEnabled = simpleConfig.isStatisticsEnabled();
        this.isManagementEnabled = simpleConfig.isManagementEnabled();
        this.isReadThrough = simpleConfig.isReadThrough();
        this.isWriteThrough = simpleConfig.isWriteThrough();
        if (simpleConfig.getCacheLoaderFactory() != null) {
            this.cacheLoaderFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleConfig.getCacheLoaderFactory());
        }
        if (simpleConfig.getCacheWriterFactory() != null) {
            this.cacheWriterFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleConfig.getCacheWriterFactory());
        }
        this.initExpiryPolicyFactoryConfig(simpleConfig);
        this.asyncBackupCount = simpleConfig.getAsyncBackupCount();
        this.backupCount = simpleConfig.getBackupCount();
        this.inMemoryFormat = simpleConfig.getInMemoryFormat();
        if (simpleConfig.getEvictionConfig() != null) {
            this.evictionConfig = new CacheEvictionConfig(simpleConfig.getEvictionConfig());
        }
        if (simpleConfig.getWanReplicationRef() != null) {
            this.wanReplicationRef = new WanReplicationRef(simpleConfig.getWanReplicationRef());
        }
        for (CacheSimpleEntryListenerConfig simpleListener : simpleConfig.getCacheEntryListeners()) {
            Factory listenerFactory = null;
            Factory filterFactory = null;
            if (simpleListener.getCacheEntryListenerFactory() != null) {
                listenerFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleListener.getCacheEntryListenerFactory());
            }
            if (simpleListener.getCacheEntryEventFilterFactory() != null) {
                filterFactory = (Factory)ClassLoaderUtil.newInstance(null, simpleListener.getCacheEntryEventFilterFactory());
            }
            boolean isOldValueRequired = simpleListener.isOldValueRequired();
            boolean synchronous = simpleListener.isSynchronous();
            MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration(listenerFactory, filterFactory, isOldValueRequired, synchronous);
            this.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfiguration);
        }
    }

    private void initExpiryPolicyFactoryConfig(CacheSimpleConfig simpleConfig) throws Exception {
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = simpleConfig.getExpiryPolicyFactoryConfig();
        if (expiryPolicyFactoryConfig != null) {
            if (expiryPolicyFactoryConfig.getClassName() != null) {
                this.expiryPolicyFactory = (Factory)ClassLoaderUtil.newInstance(null, expiryPolicyFactoryConfig.getClassName());
            } else {
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
                if (timedExpiryPolicyConfig != null) {
                    CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = timedExpiryPolicyConfig.getDurationConfig();
                    CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = timedExpiryPolicyConfig.getExpiryPolicyType();
                    switch (expiryPolicyType) {
                        case CREATED: {
                            this.expiryPolicyFactory = CreatedExpiryPolicy.factoryOf(new Duration(durationConfig.getTimeUnit(), durationConfig.getDurationAmount()));
                            break;
                        }
                        case MODIFIED: {
                            this.expiryPolicyFactory = ModifiedExpiryPolicy.factoryOf(new Duration(durationConfig.getTimeUnit(), durationConfig.getDurationAmount()));
                            break;
                        }
                        case ACCESSED: {
                            this.expiryPolicyFactory = AccessedExpiryPolicy.factoryOf(new Duration(durationConfig.getTimeUnit(), durationConfig.getDurationAmount()));
                            break;
                        }
                        case TOUCHED: {
                            this.expiryPolicyFactory = TouchedExpiryPolicy.factoryOf(new Duration(durationConfig.getTimeUnit(), durationConfig.getDurationAmount()));
                            break;
                        }
                        case ETERNAL: {
                            this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported expiry policy type: " + (Object)((Object)expiryPolicyType));
                        }
                    }
                }
            }
        }
    }

    public CacheConfigReadOnly<K, V> getAsReadOnly() {
        return new CacheConfigReadOnly(this);
    }

    public String getName() {
        return this.name;
    }

    public CacheConfig<K, V> setName(String name) {
        this.name = name;
        return this;
    }

    public String getManagerPrefix() {
        return this.managerPrefix;
    }

    public CacheConfig<K, V> setManagerPrefix(String managerPrefix) {
        this.managerPrefix = managerPrefix;
        return this;
    }

    public String getUriString() {
        return this.uriString;
    }

    public CacheConfig<K, V> setUriString(String uriString) {
        this.uriString = uriString;
        return this;
    }

    public String getNameWithPrefix() {
        return this.managerPrefix + this.name;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public CacheConfig<K, V> setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public CacheConfig<K, V> setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public CacheEvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public CacheConfig setEvictionConfig(EvictionConfig evictionConfig) {
        Preconditions.isNotNull(evictionConfig, "Eviction config cannot be null !");
        this.evictionConfig = evictionConfig instanceof CacheEvictionConfig ? (CacheEvictionConfig)evictionConfig : new CacheEvictionConfig(evictionConfig);
        return this;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public CacheConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        this.wanReplicationRef = wanReplicationRef;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public CacheConfig<K, V> setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = Preconditions.isNotNull(inMemoryFormat, "In-Memory format cannot be null !");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.managerPrefix);
        out.writeUTF(this.uriString);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeUTF(this.inMemoryFormat.name());
        out.writeObject(this.evictionConfig);
        out.writeObject(this.wanReplicationRef);
        out.writeObject(this.keyType);
        out.writeObject(this.valueType);
        out.writeObject(this.cacheLoaderFactory);
        out.writeObject(this.cacheWriterFactory);
        out.writeObject(this.expiryPolicyFactory);
        out.writeBoolean(this.isReadThrough);
        out.writeBoolean(this.isWriteThrough);
        out.writeBoolean(this.isStoreByValue);
        out.writeBoolean(this.isManagementEnabled);
        out.writeBoolean(this.isStatisticsEnabled);
        boolean listNotEmpty = this.listenerConfigurations != null && !this.listenerConfigurations.isEmpty();
        out.writeBoolean(listNotEmpty);
        if (listNotEmpty) {
            out.writeInt(this.listenerConfigurations.size());
            for (CacheEntryListenerConfiguration cc : this.listenerConfigurations) {
                out.writeObject(cc);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.managerPrefix = in.readUTF();
        this.uriString = in.readUTF();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        String resultInMemoryFormat = in.readUTF();
        this.inMemoryFormat = InMemoryFormat.valueOf(resultInMemoryFormat);
        this.evictionConfig = (CacheEvictionConfig)in.readObject();
        this.wanReplicationRef = (WanReplicationRef)in.readObject();
        this.keyType = (Class)in.readObject();
        this.valueType = (Class)in.readObject();
        this.cacheLoaderFactory = (Factory)in.readObject();
        this.cacheWriterFactory = (Factory)in.readObject();
        this.expiryPolicyFactory = (Factory)in.readObject();
        this.isReadThrough = in.readBoolean();
        this.isWriteThrough = in.readBoolean();
        this.isStoreByValue = in.readBoolean();
        this.isManagementEnabled = in.readBoolean();
        this.isStatisticsEnabled = in.readBoolean();
        boolean listNotEmpty = in.readBoolean();
        if (listNotEmpty) {
            int size = in.readInt();
            this.listenerConfigurations = this.createConcurrentSet();
            for (int i = 0; i < size; ++i) {
                this.listenerConfigurations.add((CacheEntryListenerConfiguration)in.readObject());
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.managerPrefix != null ? this.managerPrefix.hashCode() : 0);
        result = 31 * result + (this.uriString != null ? this.uriString.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CacheConfig)) {
            return false;
        }
        CacheConfig that = (CacheConfig)o;
        if (this.managerPrefix != null ? !this.managerPrefix.equals(that.managerPrefix) : that.managerPrefix != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.uriString != null ? !this.uriString.equals(that.uriString) : that.uriString != null) {
            return false;
        }
        return super.equals(o);
    }

    public String toString() {
        return "CacheConfig{name='" + this.name + '\'' + ", managerPrefix='" + this.managerPrefix + '\'' + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", backupCount=" + this.backupCount + '}';
    }
}

