/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.Lookup;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

class EjbHttpProxyHandler
implements InvocationHandler {
    private final WebTarget target;
    private final MultivaluedMap<String, Object> headers;
    private final List<Cookie> cookies;
    private final String lookup;
    private final Map<String, Object> jndiOptions;

    EjbHttpProxyHandler(WebTarget target, MultivaluedMap<String, Object> headers, List<Cookie> cookies, String lookup, Map<String, Object> jndiOptions) {
        this.target = target;
        this.headers = headers;
        this.cookies = cookies;
        this.lookup = lookup;
        this.jndiOptions = jndiOptions;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] argValues) throws Throwable {
        if (argValues == null && method.getName().equals("toString")) {
            return this.toString();
        }
        if (argValues == null && method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (argValues != null && argValues.length == 1 && method.getName().equals("equals")) {
            return this.equals(argValues[0]);
        }
        return this.doRemoteInvoke(proxy, method, argValues);
    }

    public Object doRemoteInvoke(Object proxy, Method method, Object[] argValues) throws Throwable {
        String httpMethod = "POST";
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("lookup", this.lookup);
        payload.put("method", method.getName());
        payload.put("argTypes", Arrays.stream(method.getParameterTypes()).map(Class::getName).toArray());
        payload.put("argValues", argValues == null ? new Object[]{} : argValues);
        if (this.jndiOptions.containsKey("java.naming.security.principal")) {
            payload.put("java.naming.security.principal", Lookup.base64Encode(this.jndiOptions.get("java.naming.security.principal")));
        }
        if (this.jndiOptions.containsKey("java.naming.security.credentials")) {
            payload.put("java.naming.security.credentials", Lookup.base64Encode(this.jndiOptions.get("java.naming.security.credentials")));
        }
        Entity entity = Entity.entity(payload, (String)"application/json");
        Class<Object> responseType = method.getReturnType();
        GenericType responseGenericType = new GenericType(method.getGenericReturnType());
        WebTarget newTarget = EjbHttpProxyHandler.addPathFromMethod(method, this.target);
        Invocation.Builder builder = newTarget.request();
        builder.headers((MultivaluedMap)new MultivaluedHashMap(this.headers));
        for (Cookie cookie : new LinkedList<Cookie>(this.cookies)) {
            builder = builder.cookie(cookie);
        }
        if (responseType.isAssignableFrom(CompletionStage.class)) {
            return builder.rx().method(httpMethod, entity, this.getResponseParameterizedType(method, responseGenericType));
        }
        if (responseType.isAssignableFrom(Future.class)) {
            return builder.async().method(httpMethod, entity, this.getResponseParameterizedType(method, responseGenericType));
        }
        return builder.method(httpMethod, entity, responseGenericType);
    }

    private GenericType<?> getResponseParameterizedType(Method method, GenericType<?> responseGenericType) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            return new GenericType(parameterizedType.getActualTypeArguments()[0]);
        }
        return responseGenericType;
    }

    private static WebTarget addPathFromMethod(Method method, WebTarget target) {
        return target.path(method.getName());
    }

    public String toString() {
        return this.target.toString();
    }
}

