/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client.adapter;

import fish.payara.ejb.http.client.adapter.ClientAdapter;
import fish.payara.ejb.http.client.adapter.CompositeClientAdapter;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.naming.Context;
import javax.naming.NamingException;

public final class ClientAdapterCustomizer
implements ClientAdapter {
    private final Supplier<ClientAdapter> downstreamAdapter;
    private Predicate<String> namePredicate;
    private Function<String, String> nameTransformation = Function.identity();

    ClientAdapterCustomizer(Supplier<ClientAdapter> downstreamAdapter) {
        this.downstreamAdapter = downstreamAdapter;
    }

    private ClientAdapterCustomizer(ClientAdapterCustomizer previous) {
        this.downstreamAdapter = previous.downstreamAdapter;
        this.namePredicate = previous.namePredicate;
        this.nameTransformation = previous.nameTransformation;
    }

    @Override
    public Optional<Object> makeLocalProxy(String jndiName, Context remoteContext) throws NamingException {
        if (this.namePredicate == null || this.namePredicate.test(jndiName)) {
            return this.downstreamAdapter.get().makeLocalProxy(this.nameTransformation.apply(jndiName), remoteContext);
        }
        return Optional.empty();
    }

    public ClientAdapterCustomizer matchName(Predicate<String> name) {
        ClientAdapterCustomizer conditional = new ClientAdapterCustomizer(this);
        conditional.namePredicate = name;
        return conditional;
    }

    public ClientAdapterCustomizer transformName(Function<String, String> nameTransformation) {
        ClientAdapterCustomizer conditional = new ClientAdapterCustomizer(this);
        conditional.nameTransformation = nameTransformation != null ? nameTransformation : Function.identity();
        return conditional;
    }

    public ClientAdapterCustomizer matchPrefix(String prefix) {
        return this.matchName(name -> name.startsWith(prefix)).transformName(name -> name.substring(prefix.length()));
    }

    public static ClientAdapterCustomizer customize(Class<? extends ClientAdapter> adapterClass) {
        return ClientAdapterCustomizer.customize(CompositeClientAdapter.Builder.instantiate(adapterClass));
    }

    public static ClientAdapterCustomizer customize(ClientAdapter adapterInstance) {
        return ClientAdapterCustomizer.customize(() -> adapterInstance);
    }

    public static ClientAdapterCustomizer customize(Supplier<ClientAdapter> adapterSupplier) {
        return new ClientAdapterCustomizer(adapterSupplier);
    }
}

