/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.http.client;

import fish.payara.ejb.http.client.EjbHttpProxyFactory;
import fish.payara.ejb.http.client.adapter.ClientAdapter;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;

class RemoteEJBContext
implements Context {
    private ClientAdapter clientAdapter;
    private Hashtable<String, Object> environment;

    public RemoteEJBContext(Hashtable<?, ?> environment) {
        Object adapter;
        this.environment = environment;
        if (environment.containsKey("fish.payara.clientAdapter") && (adapter = environment.get("fish.payara.clientAdapter")) instanceof ClientAdapter) {
            this.clientAdapter = (ClientAdapter)adapter;
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("Lookup name cannot be null");
        }
        String url = (String)this.environment.get("java.naming.provider.url");
        try {
            Optional<Object> resolvedAdapter;
            if (this.clientAdapter != null && (resolvedAdapter = this.clientAdapter.makeLocalProxy(name, this)).isPresent()) {
                return resolvedAdapter.get();
            }
            ClientBuilder clientBuilder = this.getClientBuilder();
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("lookup", name);
            URI remotePayaraURI = new URL(url).toURI();
            String className = (String)clientBuilder.build().target(remotePayaraURI).path("ejb").path("lookup").request().post(Entity.entity(payload, (String)"application/json")).readEntity(String.class);
            return EjbHttpProxyFactory.newProxy(Class.forName(className), clientBuilder.build().target(remotePayaraURI).path("ejb").path("invoke"), name, new HashMap<String, Object>(this.environment));
        }
        catch (Exception e) {
            throw this.newNamingException(name, e);
        }
    }

    private ClientBuilder getClientBuilder() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (this.environment.containsKey("fish.payara.connectTimeout")) {
            clientBuilder.connectTimeout(this.getLong(this.environment.get("fish.payara.connectTimeout")).longValue(), TimeUnit.MICROSECONDS);
        }
        if (this.environment.contains("fish.payara.executorService")) {
            clientBuilder.executorService(this.getInstance(this.environment.get("fish.payara.executorService"), ExecutorService.class));
        }
        if (this.environment.contains("fish.payara.hostnameVerifier")) {
            clientBuilder.hostnameVerifier(this.getInstance(this.environment.get("fish.payara.hostnameVerifier"), HostnameVerifier.class));
        }
        if (this.environment.contains("fish.payara.keyStore")) {
            clientBuilder.keyStore(this.getInstance(this.environment.get("fish.payara.keyStore"), KeyStore.class), this.getPassword(this.environment.get("keyStorePassword")));
        }
        if (this.environment.containsKey("fish.payara.readTimeout")) {
            clientBuilder.readTimeout(this.getLong(this.environment.get("fish.payara.readTimeout")).longValue(), TimeUnit.MICROSECONDS);
        }
        if (this.environment.contains("fish.payara.scheduledExecutorService")) {
            clientBuilder.scheduledExecutorService(this.getInstance(this.environment.get("fish.payara.scheduledExecutorService"), ScheduledExecutorService.class));
        }
        if (this.environment.contains("fish.payara.sslContext")) {
            clientBuilder.sslContext(this.getInstance(this.environment.get("fish.payara.sslContext"), SSLContext.class));
        }
        if (this.environment.contains("fish.payara.trustStore")) {
            clientBuilder.trustStore(this.getInstance(this.environment.get("fish.payara.trustStore"), KeyStore.class));
        }
        if (this.environment.contains("fish.payara.withConfig")) {
            clientBuilder.withConfig(this.getInstance(this.environment.get("fish.payara.withConfig"), Configuration.class));
        }
        return clientBuilder;
    }

    private NamingException newNamingException(String name, Exception cause) {
        NamingException namingException = new NamingException("Could not lookup :" + name);
        namingException.initCause(cause);
        return namingException;
    }

    private <T> T getInstance(Object value, Class<T> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        if (value instanceof String) {
            return clazz.cast(Class.forName((String)value).newInstance());
        }
        throw new IllegalStateException("Value " + value + " has to be of type String or " + clazz);
    }

    private Long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new IllegalStateException("Value " + value + " has to be of type String or Number");
    }

    private char[] getPassword(Object value) {
        if (value instanceof String) {
            return ((String)value).toCharArray();
        }
        if (value instanceof char[]) {
            return (char[])value;
        }
        throw new IllegalArgumentException("No password provided");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        this.environment.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

