/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.inbound;

import fish.payara.cloud.connectors.kafka.api.KafkaListener;
import fish.payara.cloud.connectors.kafka.tools.AdditionalPropertiesParser;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.Activation;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;

@Activation(messageListeners={KafkaListener.class})
public class KafkaActivationSpec
implements ActivationSpec {
    private final Properties consumerProperties = new Properties();
    private AdditionalPropertiesParser additionalPropertiesParser;
    private ResourceAdapter ra;
    private Long autoCommitInterval;
    private String bootstrapServersConfig;
    private String clientId;
    private Boolean enableAutoCommit = true;
    private String groupIdConfig;
    private String valueDeserializer;
    private String keyDeserializer;
    private String topics;
    private Long pollInterval = 1000L;
    private Long initialPollDelay = 1000L;
    private Long fetchMinBytes;
    private Long fetchMaxBytes;
    private Integer heartbeatInterval;
    private Integer maxPartitionFetchBytes;
    private Integer sessionTimeout;
    private String autoOffsetReset;
    private Long connectionsMaxIdle;
    private Integer receiveBuffer;
    private Integer requestTimeout;
    private Boolean checkCRCs;
    private Integer fetchMaxWait;
    private Long metadataMaxAge;
    private Long reconnectBackoff;
    private Long retryBackoff;
    private String additionalProperties;
    private Boolean commitEachPoll = false;
    private Boolean useSynchMode = false;

    public void validate() throws InvalidPropertyException {
        if (this.bootstrapServersConfig == null) {
            throw new InvalidPropertyException("bootstrapServersConfig is a mandatory property");
        }
        if (this.keyDeserializer == null) {
            throw new InvalidPropertyException("keyDeserializer is a mandatory property");
        }
        if (this.valueDeserializer == null) {
            throw new InvalidPropertyException("valueDeserializer is a mandatory property");
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.ra = ra;
    }

    public Boolean getCommitEachPoll() {
        return this.commitEachPoll;
    }

    public void setCommitEachPoll(Boolean commitEachPoll) {
        this.commitEachPoll = commitEachPoll;
    }

    public Long getAutoCommitInterval() {
        return this.autoCommitInterval;
    }

    public void setAutoCommitInterval(Long autoCommitInterval) {
        this.autoCommitInterval = autoCommitInterval;
        this.consumerProperties.setProperty("auto.commit.interval.ms", Long.toString(autoCommitInterval));
    }

    public Boolean getUseSynchMode() {
        return this.useSynchMode;
    }

    public void setUseSynchMode(Boolean useSynchMode) {
        this.useSynchMode = useSynchMode;
    }

    public String getBootstrapServersConfig() {
        return this.bootstrapServersConfig;
    }

    public void setBootstrapServersConfig(String bootstrapServersConfig) {
        this.bootstrapServersConfig = bootstrapServersConfig;
        this.consumerProperties.setProperty("bootstrap.servers", bootstrapServersConfig);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.consumerProperties.setProperty("client.id", clientId);
    }

    public Boolean getEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(Boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
        this.consumerProperties.setProperty("enable.auto.commit", Boolean.toString(enableAutoCommit));
    }

    public String getGroupIdConfig() {
        return this.groupIdConfig;
    }

    public void setGroupIdConfig(String groupIdConfig) {
        this.groupIdConfig = groupIdConfig;
        this.consumerProperties.setProperty("group.id", groupIdConfig);
    }

    public String getValueDeserializer() {
        return this.valueDeserializer;
    }

    public void setValueDeserializer(String valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
        this.consumerProperties.setProperty("value.deserializer", valueDeserializer);
    }

    public String getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public void setKeyDeserializer(String keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
        this.consumerProperties.setProperty("key.deserializer", keyDeserializer);
    }

    public Long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(Long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public Properties getConsumerProperties() {
        return this.additionalPropertiesParser == null ? this.consumerProperties : AdditionalPropertiesParser.merge(this.consumerProperties, this.additionalPropertiesParser.parse());
    }

    public String getTopics() {
        return this.topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public Long getInitialPollDelay() {
        return this.initialPollDelay;
    }

    public void setInitialPollDelay(Long initialPollDelay) {
        this.initialPollDelay = initialPollDelay;
    }

    public ResourceAdapter getRa() {
        return this.ra;
    }

    public void setRa(ResourceAdapter ra) {
        this.ra = ra;
    }

    public Long getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public void setFetchMinBytes(Long fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
        this.consumerProperties.setProperty("fetch.min.bytes", Long.toString(fetchMinBytes));
    }

    public Long getFetchMaxBytes() {
        return this.fetchMaxBytes;
    }

    public void setFetchMaxBytes(Long fetchMaxBytes) {
        this.fetchMaxBytes = fetchMaxBytes;
        this.consumerProperties.setProperty("max.partition.fetch.bytes", Long.toString(fetchMaxBytes));
    }

    public Integer getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Integer heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        this.consumerProperties.setProperty("heartbeat.interval.ms", Integer.toString(heartbeatInterval));
    }

    public Integer getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes;
    }

    public void setMaxPartitionFetchBytes(Integer maxPartitionFetchBytes) {
        this.maxPartitionFetchBytes = maxPartitionFetchBytes;
        this.consumerProperties.setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.consumerProperties.setProperty("session.timeout.ms", Integer.toString(sessionTimeout));
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
        this.consumerProperties.setProperty("auto.offset.reset", autoOffsetReset);
    }

    public Long getConnectionsMaxIdle() {
        return this.connectionsMaxIdle;
    }

    public void setConnectionsMaxIdle(Long connectionsMaxIdle) {
        this.connectionsMaxIdle = connectionsMaxIdle;
        this.consumerProperties.setProperty("connections.max.idle.ms", Long.toString(connectionsMaxIdle));
    }

    public Integer getReceiveBuffer() {
        return this.receiveBuffer;
    }

    public void setReceiveBuffer(Integer receiveBuffer) {
        this.receiveBuffer = receiveBuffer;
        this.consumerProperties.setProperty("receive.buffer.bytes", Integer.toString(receiveBuffer));
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.consumerProperties.setProperty("request.timeout.ms", Integer.toString(requestTimeout));
    }

    public Boolean getCheckCRCs() {
        return this.checkCRCs;
    }

    public void setCheckCRCs(Boolean checkCRCs) {
        this.checkCRCs = checkCRCs;
        this.consumerProperties.setProperty("check.crcs", Boolean.toString(checkCRCs));
    }

    public Integer getFetchMaxWait() {
        return this.fetchMaxWait;
    }

    public void setFetchMaxWait(Integer fetchMaxWait) {
        this.fetchMaxWait = fetchMaxWait;
        this.consumerProperties.setProperty("fetch.max.wait.ms", Integer.toString(fetchMaxWait));
    }

    public Long getMetadataMaxAge() {
        return this.metadataMaxAge;
    }

    public void setMetadataMaxAge(Long metadataMaxAge) {
        this.metadataMaxAge = metadataMaxAge;
        this.consumerProperties.setProperty("metadata.max.age.ms", Long.toString(metadataMaxAge));
    }

    public Long getReconnectBackoff() {
        return this.reconnectBackoff;
    }

    public void setReconnectBackoff(Long reconnectBackoff) {
        this.reconnectBackoff = reconnectBackoff;
        this.consumerProperties.setProperty("reconnect.backoff.ms", Long.toString(reconnectBackoff));
    }

    public Long getRetryBackoff() {
        return this.retryBackoff;
    }

    public void setRetryBackoff(Long retryBackoff) {
        this.retryBackoff = retryBackoff;
        this.consumerProperties.setProperty("retry.backoff.ms", Long.toString(retryBackoff));
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(String additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.additionalPropertiesParser = new AdditionalPropertiesParser(additionalProperties);
    }
}

