/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.tools;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class AdditionalPropertiesParser {
    private static final Logger LOG = Logger.getLogger(AdditionalPropertiesParser.class.getName());
    private static final String LIST_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private String propertiesString;

    public AdditionalPropertiesParser(String propertiesString) {
        this.propertiesString = propertiesString;
    }

    public static Properties merge(Properties base, Properties addtional) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)base);
        if (addtional != null) {
            for (String key : addtional.stringPropertyNames()) {
                properties.putIfAbsent(key, addtional.getProperty(key));
            }
        }
        return properties;
    }

    public Properties parse() {
        Properties properties = new Properties();
        if (this.propertiesString != null) {
            String[] splittedProperties;
            String lastKey = null;
            block4: for (String singleKeyValue : splittedProperties = this.propertiesString.split(LIST_SEPARATOR)) {
                Object[] splittedKeyValue = singleKeyValue.split(KEY_VALUE_SEPARATOR);
                switch (splittedKeyValue.length) {
                    case 2: {
                        String key;
                        lastKey = key = splittedKeyValue[0].trim();
                        String value = ((String)splittedKeyValue[1]).trim();
                        String existingValue = properties.getProperty(key);
                        if (existingValue != null) {
                            properties.setProperty(key, existingValue + LIST_SEPARATOR + value);
                            continue block4;
                        }
                        properties.setProperty(key, value);
                        continue block4;
                    }
                    case 1: {
                        if (lastKey == null) continue block4;
                        String value = splittedKeyValue[0].trim();
                        String existingValue = properties.getProperty(lastKey);
                        if (existingValue != null) {
                            properties.setProperty(lastKey, existingValue + LIST_SEPARATOR + value);
                            continue block4;
                        }
                        properties.setProperty(lastKey, value);
                        continue block4;
                    }
                    default: {
                        LOG.warning("Found illegal properties " + Arrays.toString(splittedKeyValue));
                    }
                }
            }
        }
        return properties;
    }
}

