/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.requesttracing;

import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpanContext;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;

public class RequestTraceSpan
implements Serializable,
Comparable<RequestTraceSpan> {
    private final RequestTraceSpanContext spanContext;
    private Instant startTime;
    private Instant endTime;
    private long spanDuration;
    private EventType eventType;
    private final Map<String, String> spanTags;
    private final List<RequestTraceSpanLog> spanLogs;
    private String eventName;
    private final List<SpanReference> spanReferences;

    protected RequestTraceSpan() {
        this.spanContext = new RequestTraceSpanContext();
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
    }

    public RequestTraceSpan(String eventName) {
        this(EventType.REQUEST_EVENT, eventName);
    }

    public RequestTraceSpan(EventType eventType, String eventName) {
        this.spanContext = new RequestTraceSpanContext();
        this.startTime = Instant.now();
        this.eventType = eventType;
        this.eventName = eventName;
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
    }

    public RequestTraceSpan(EventType eventType, String eventName, UUID propagatedTraceId, UUID propagatedParentId, SpanContextRelationshipType spanContextRelationship) {
        this.spanContext = new RequestTraceSpanContext(propagatedTraceId);
        this.startTime = Instant.now();
        this.eventType = eventType;
        this.eventName = eventName;
        this.spanTags = new HashMap<String, String>();
        this.spanLogs = new ArrayList<RequestTraceSpanLog>();
        this.spanReferences = new ArrayList<SpanReference>();
        this.spanReferences.add(new SpanReference(new RequestTraceSpanContext(propagatedTraceId, propagatedParentId), spanContextRelationship));
    }

    public UUID getId() {
        return this.spanContext.getSpanId();
    }

    public UUID getTraceId() {
        return this.spanContext.getTraceId();
    }

    public void setTraceId(UUID traceId) {
        this.spanContext.setTraceId(traceId);
    }

    public RequestTraceSpanContext getSpanContext() {
        return this.spanContext;
    }

    public Instant getStartInstant() {
        return this.startTime;
    }

    public void setStartInstant(Instant startTime) {
        this.startTime = startTime;
    }

    public long getTimeOccured() {
        return this.startTime.toEpochMilli();
    }

    public long getSpanDuration() {
        return this.spanDuration;
    }

    public void setSpanDuration(long spanTime) {
        this.spanDuration = spanTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void addSpanTag(String name, String value) {
        if (value != null) {
            this.spanTags.put(name, value.replaceAll("\"", "\\\\\""));
        } else {
            this.spanTags.put(name, value);
        }
    }

    public String getSpanTag(String tag) {
        return this.spanTags.get(tag);
    }

    public Map<String, String> getSpanTags() {
        return this.spanTags;
    }

    public void addSpanLog(RequestTraceSpanLog spanLog) {
        this.spanLogs.add(spanLog);
    }

    public void addSpanReference(RequestTraceSpanContext spanContext, SpanContextRelationshipType relationshipType) {
        ListIterator<SpanReference> iterator = this.spanReferences.listIterator();
        while (iterator.hasNext()) {
            SpanReference spanReference = iterator.next();
            if (!spanReference.getReferenceSpanContext().getSpanId().equals(spanContext.getSpanId()) || !spanReference.getSpanContextRelationshipType().equals((Object)relationshipType)) continue;
            iterator.remove();
            break;
        }
        this.spanReferences.add(new SpanReference(spanContext, relationshipType));
        for (Map.Entry<String, String> baggageItem : spanContext.baggageItems()) {
            this.spanContext.addBaggageItem(baggageItem.getKey(), baggageItem.getValue());
        }
    }

    public List<SpanReference> getSpanReferences() {
        return this.spanReferences;
    }

    public Instant getTraceEndTime() {
        return this.endTime;
    }

    public void setTraceEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public void setEventType(EventType spanType) {
        this.eventType = spanType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("\n{");
        result.append("\"operationName\":\"").append(this.eventName).append("\",").append("\"spanContext\":{").append("\"spanId\":\"").append(this.spanContext.getSpanId()).append("\",").append("\"traceId\":\"").append(this.spanContext.getTraceId()).append("\"");
        result.append("},");
        result.append("\"startTime\":\"").append(this.startTime.atZone(ZoneId.systemDefault()).toString()).append("\",");
        result.append("\"endTime\":\"").append(this.endTime.atZone(ZoneId.systemDefault()).toString()).append("\",");
        result.append("\"traceDuration\":\"").append(this.spanDuration).append("\"");
        if (this.spanTags != null && !this.spanTags.isEmpty()) {
            result.append(",\"spanTags\":[");
            for (Map.Entry entry : this.spanTags.entrySet()) {
                result.append("{\"").append((String)entry.getKey()).append("\": \"").append((String)entry.getValue()).append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        if (this.spanLogs != null && !this.spanLogs.isEmpty()) {
            result.append(",\"spanLogs\":[");
            for (RequestTraceSpanLog requestTraceSpanLog : this.spanLogs) {
                Map<String, String> logEntries = requestTraceSpanLog.getLogEntries();
                result.append("{");
                result.append("\"logDetails\":[");
                for (Map.Entry<String, String> logEntry : logEntries.entrySet()) {
                    result.append("{\"");
                    result.append(logEntry.getKey());
                    result.append("\":\"");
                    result.append(logEntry.getValue());
                    result.append("\"},");
                }
                result.deleteCharAt(result.length() - 1);
                result.append("],");
                result.append("\"logTime\":\"");
                result.append(requestTraceSpanLog.getTimeMillis());
                result.append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        if (this.spanReferences != null && !this.spanReferences.isEmpty()) {
            result.append(",\"references\":[");
            for (SpanReference spanReference : this.spanReferences) {
                result.append("{\"spanContext\":{").append("\"spanId\":\"").append(spanReference.getReferenceSpanContext().getSpanId()).append("\",").append("\"traceId\":\"").append(spanReference.getReferenceSpanContext().getTraceId()).append("\"},");
                result.append("\"relationshipType\":\"").append((Object)spanReference.getSpanContextRelationshipType()).append("\"},");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public int compareTo(RequestTraceSpan span) {
        return this.startTime.compareTo(span.startTime);
    }

    public static enum SpanContextRelationshipType {
        ChildOf,
        FollowsFrom;

    }

    public class SpanReference
    implements Serializable {
        private final RequestTraceSpanContext referenceSpanContext;
        private final SpanContextRelationshipType relationshipType;

        private SpanReference(RequestTraceSpanContext referenceSpanContext, SpanContextRelationshipType relationshipType) {
            this.referenceSpanContext = referenceSpanContext;
            this.relationshipType = relationshipType;
        }

        public RequestTraceSpanContext getReferenceSpanContext() {
            return this.referenceSpanContext;
        }

        public SpanContextRelationshipType getSpanContextRelationshipType() {
            return this.relationshipType;
        }
    }
}

