/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SwitchHandler;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Visitor;

public class SwitchFallthrough
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = Boolean.getBoolean("switchFallthrough.debug");
    private static final boolean LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT = Boolean.getBoolean("findbugs.sf.comment");
    private SwitchHandler switchHdlr;
    private boolean reachable;
    private BugReporter bugReporter;
    private int lastPC;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();

    public SwitchFallthrough(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(Code obj) {
        this.reachable = false;
        this.lastPC = 0;
        this.found.clear();
        this.switchHdlr = new SwitchHandler();
        super.visit(obj);
        if (!this.found.isEmpty() && this.found.size() < 4) {
            BugInstance bug = new BugInstance((Detector)this, "SF_SWITCH_FALLTHROUGH", 2).addClassAndMethod((PreorderVisitor)this).addAnnotations(this.found);
            this.bugReporter.reportBug(bug);
        }
    }

    public void sawOpcode(int seen) {
        SourceLineAnnotation sourceLineAnnotation;
        if (this.reachable && this.switchHdlr.isOnSwitchOffset((DismantleBytecode)this) && !this.hasFallThruComment(this.lastPC + 1, this.getPC() - 1) && (sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange((ClassContext)this.getClassContext(), (PreorderVisitor)this, (int)this.lastPC, (int)this.getPC())) != null) {
            this.found.add(sourceLineAnnotation);
        }
        switch (seen) {
            case 170: 
            case 171: {
                this.reachable = false;
                this.switchHdlr.enterSwitch((DismantleBytecode)this);
                break;
            }
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                this.reachable = false;
                break;
            }
            case 184: {
                this.reachable = !"exit".equals(this.getNameConstantOperand()) || !"java/lang/System".equals(this.getClassConstantOperand());
                break;
            }
            default: {
                this.reachable = true;
            }
        }
        this.lastPC = this.getPC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFallThruComment(int startPC, int endPC) {
        if (!LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT) return false;
        BufferedReader r = null;
        try {
            String line;
            int i;
            SourceLineAnnotation srcLine = SourceLineAnnotation.fromVisitedInstructionRange((BytecodeScanningDetector)this, (int)this.lastPC, (int)this.getPC());
            SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
            SourceFile sourceFile = sourceFinder.findSourceFile(srcLine.getPackageName(), srcLine.getSourceFile());
            int startLine = srcLine.getStartLine();
            int numLines = srcLine.getEndLine() - startLine - 1;
            if (numLines <= 0) {
                boolean bl = false;
                return bl;
            }
            r = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
            for (i = 0; i < startLine; ++i) {
                line = r.readLine();
                if (line != null) continue;
                boolean bl = false;
                return bl;
            }
            i = 0;
            while (i < numLines) {
                line = r.readLine();
                if (line == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((line = line.toLowerCase()).indexOf("fall") >= 0 || line.indexOf("nobreak") >= 0) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

