/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FieldWarningSuppressor;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.MethodWarningSuppressor;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.PackageWarningSuppressor;
import edu.umd.cs.findbugs.SuppressionMatcher;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteSuppressedWarnings
extends AnnotationVisitor
implements NonReportingDetector {
    private static Set<String> packages = new HashSet<String>();
    private SuppressionMatcher suppressionMatcher;
    private NoteSuppressedWarnings recursiveDetector;

    public NoteSuppressedWarnings(BugReporter bugReporter) {
        this(bugReporter, false);
    }

    public NoteSuppressedWarnings(BugReporter bugReporter, boolean recursive) {
        if (!recursive) {
            DelegatingBugReporter b = (DelegatingBugReporter)bugReporter;
            BugReporter origBugReporter = b.getDelegate();
            this.suppressionMatcher = new SuppressionMatcher();
            FilterBugReporter filterBugReporter = new FilterBugReporter(origBugReporter, (Matcher)this.suppressionMatcher, false);
            b.setDelegate((BugReporter)filterBugReporter);
            this.recursiveDetector = new NoteSuppressedWarnings(bugReporter, true);
            this.recursiveDetector.suppressionMatcher = this.suppressionMatcher;
        }
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(JavaClass obj) {
        if (this.recursiveDetector == null) {
            return;
        }
        try {
            if (this.getClassName().endsWith("package-info")) {
                return;
            }
            String packageName = this.getPackageName().replace('/', '.');
            if (!packages.add(packageName)) {
                return;
            }
            String packageInfo = "package-info";
            if (packageName.length() > 0) {
                packageInfo = new StringBuffer().append(packageName).append(".").append(packageInfo).toString();
            }
            JavaClass packageInfoClass = Repository.lookupClass((String)packageInfo);
            this.recursiveDetector.visitJavaClass(packageInfoClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!annotationClass.endsWith("SuppressWarnings")) {
            return;
        }
        Object value = map.get("value");
        if (value == null || !(value instanceof Object[])) {
            this.suppressWarning(null);
            return;
        }
        Object[] suppressedWarnings = (Object[])value;
        if (suppressedWarnings.length == 0) {
            this.suppressWarning(null);
        } else {
            for (Object suppressedWarning : suppressedWarnings) {
                this.suppressWarning((String)suppressedWarning);
            }
        }
    }

    private void suppressWarning(String pattern) {
        String className = this.getDottedClassName();
        ClassAnnotation clazz = new ClassAnnotation(className);
        if (className.endsWith("package-info") && this.recursiveDetector == null) {
            this.suppressionMatcher.addPackageSuppressor(new PackageWarningSuppressor(pattern, this.getPackageName().replace('/', '.')));
        } else if (this.visitingMethod()) {
            this.suppressionMatcher.addSuppressor((ClassWarningSuppressor)new MethodWarningSuppressor(pattern, clazz, MethodAnnotation.fromVisitedMethod((PreorderVisitor)this)));
        } else if (this.visitingField()) {
            this.suppressionMatcher.addSuppressor((ClassWarningSuppressor)new FieldWarningSuppressor(pattern, clazz, FieldAnnotation.fromVisitedField((PreorderVisitor)this)));
        } else {
            this.suppressionMatcher.addSuppressor(new ClassWarningSuppressor(pattern, clazz));
        }
    }

    public void report() {
    }
}

