/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CallGraph;
import edu.umd.cs.findbugs.CallGraphEdge;
import edu.umd.cs.findbugs.CallGraphNode;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.SelfCalls;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockChecker;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.detect.InconsistentSyncWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindInconsistentSync2
implements Detector {
    private static final boolean DEBUG;
    private static final boolean SYNC_ACCESS = true;
    private static final boolean ADJUST_SUBCLASS_ACCESSES;
    private static final boolean EVAL;
    private static final int MIN_SYNC_PERCENT;
    private static final double WRITE_BIAS;
    private static final double UNSYNC_FACTOR;
    private static final int UNLOCKED = 0;
    private static final int LOCKED = 1;
    private static final int READ = 0;
    private static final int WRITE = 2;
    private static final int READ_UNLOCKED = 0;
    private static final int WRITE_UNLOCKED = 2;
    private static final int READ_LOCKED = 1;
    private static final int WRITE_LOCKED = 3;
    private BugReporter bugReporter;
    private Map<XField, FieldStats> statMap = new HashMap<XField, FieldStats>();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindInconsistentSync2;

    public FindInconsistentSync2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Set<Method> publicReachableMethods;
        Set<Method> lockedMethodSet;
        JavaClass javaClass = classContext.getJavaClass();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("******** Analyzing class ").append(javaClass.getClassName()).toString());
        }
        SelfCalls selfCalls = new SelfCalls(classContext){

            public boolean wantCallsFor(Method method) {
                return !method.isPublic();
            }
        };
        try {
            selfCalls.execute();
            CallGraph callGraph = selfCalls.getCallGraph();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Call graph (not unlocked methods): ").append(callGraph.getNumVertices()).append(" nodes, ").append(callGraph.getNumEdges()).append(" edges").toString());
            }
            Set<CallSite> obviouslyLockedSites = this.findObviouslyLockedCallSites(classContext, selfCalls);
            lockedMethodSet = this.findNotUnlockedMethods(classContext, selfCalls, obviouslyLockedSites);
            lockedMethodSet.retainAll(this.findLockedMethods(classContext, selfCalls, obviouslyLockedSites));
            publicReachableMethods = this.findPublicReachableMethods(classContext, selfCalls);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error finding locked call sites", (Throwable)e);
            return;
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("Error finding locked call sites", (Throwable)e);
            return;
        }
        for (Method method : publicReachableMethods) {
            if (classContext.getMethodGen(method) == null || method.getName().startsWith("access$")) continue;
            try {
                this.analyzeMethod(classContext, method, lockedMethodSet);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing method", (Throwable)e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing method", (Throwable)e);
            }
        }
    }

    public void report() {
        for (XField xfield : this.statMap.keySet()) {
            SourceLineAnnotation accessSourceLine;
            int priority;
            int freq;
            FieldStats stats = this.statMap.get(xfield);
            JCIPAnnotationDatabase jcipAnotationDatabase = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase();
            boolean guardedByThis = "this".equals(jcipAnotationDatabase.getFieldAnnotation(xfield, "GuardedBy"));
            boolean notThreadSafe = jcipAnotationDatabase.hasClassAnnotation(xfield.getClassName(), "NotThreadSafe");
            boolean threadSafe = jcipAnotationDatabase.hasClassAnnotation(xfield.getClassName().replace('/', '.'), "ThreadSafe");
            if (notThreadSafe) continue;
            WarningPropertySet propertySet = new WarningPropertySet();
            int numReadUnlocked = stats.getNumAccesses(0);
            int numWriteUnlocked = stats.getNumAccesses(2);
            int numReadLocked = stats.getNumAccesses(1);
            int numWriteLocked = stats.getNumAccesses(3);
            int locked = numReadLocked + numWriteLocked;
            int biasedLocked = numReadLocked + (int)(WRITE_BIAS * (double)numWriteLocked);
            int unlocked = numReadUnlocked + numWriteUnlocked;
            int biasedUnlocked = numReadUnlocked + (int)(WRITE_BIAS * (double)numWriteUnlocked);
            int writes = numWriteLocked + numWriteUnlocked;
            if (unlocked == 0) continue;
            if (guardedByThis) {
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.ANNOTATED_AS_GUARDED_BY_THIS);
            }
            if (threadSafe) {
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.ANNOTATED_AS_THREAD_SAFE);
            }
            if (!guardedByThis && locked == 0) continue;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("IS2: ").append(xfield).toString());
                if (guardedByThis) {
                    System.out.println("Guarded by this");
                }
                System.out.println(new StringBuffer().append("  RL: ").append(numReadLocked).toString());
                System.out.println(new StringBuffer().append("  WL: ").append(numWriteLocked).toString());
                System.out.println(new StringBuffer().append("  RU: ").append(numReadUnlocked).toString());
                System.out.println(new StringBuffer().append("  WU: ").append(numWriteUnlocked).toString());
            }
            if (!EVAL && numReadUnlocked > 0 && (int)(UNSYNC_FACTOR * (double)biasedUnlocked) > biasedLocked) {
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.MANY_BIASED_UNLOCKED);
            }
            if (numWriteUnlocked + numWriteLocked == 0) {
                if (DEBUG) {
                    System.out.println("  No writes outside of constructor");
                }
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.NEVER_WRITTEN);
            }
            if (numReadUnlocked + numReadLocked == 0) {
                if (DEBUG) {
                    System.out.println("  No reads outside of constructor");
                }
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.NEVER_READ);
            }
            if (stats.getNumLocalLocks() == 0) {
                if (DEBUG) {
                    System.out.println("  No local locks");
                }
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.NO_LOCAL_LOCKS);
            }
            if ((freq = locked + unlocked > 0 ? 100 * locked / (locked + unlocked) : 0) < MIN_SYNC_PERCENT) {
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.BELOW_MIN_SYNC_PERCENT);
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("  Sync %: ").append(freq).toString());
            }
            if (stats.getNumGetterMethodAccesses() >= unlocked) {
                propertySet.addProperty((WarningProperty)InconsistentSyncWarningProperty.ONLY_UNSYNC_IN_GETTERS);
            }
            if (propertySet.isFalsePositive(priority = propertySet.computePriority(2))) continue;
            BugInstance bugInstance = new BugInstance(guardedByThis ? "IS_FIELD_NOT_GUARDED" : "IS2_INCONSISTENT_SYNC", priority).addClass(xfield.getClassName()).addField(xfield).addInt(freq).describe("INT_SYNC_PERCENT");
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                propertySet.decorateBugInstance(bugInstance);
            }
            Iterator<SourceLineAnnotation> j = stats.unsyncAccessIterator();
            while (j.hasNext()) {
                accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_UNSYNC_ACCESS");
            }
            j = stats.syncAccessIterator();
            while (j.hasNext()) {
                accessSourceLine = j.next();
                bugInstance.addSourceLine(accessSourceLine).describe("SOURCE_LINE_SYNC_ACCESS");
            }
            if (EVAL) {
                bugInstance.addInt(biasedLocked).describe("INT_BIASED_LOCKED");
                bugInstance.addInt(biasedUnlocked).describe("INT_BIASED_UNLOCKED");
            }
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private static boolean isConstructor(String methodName) {
        return methodName.equals("<init>") || methodName.equals("<clinit>") || methodName.equals("readObject") || methodName.equals("clone") || methodName.equals("close") || methodName.equals("writeObject") || methodName.equals("toString") || methodName.equals("init") || methodName.equals("initialize") || methodName.equals("dispose") || methodName.equals("finalize") || methodName.equals("this");
    }

    private void analyzeMethod(ClassContext classContext, Method method, Set<Method> lockedMethodSet) throws CFGBuilderException, DataflowAnalysisException {
        InnerClassAccessMap icam = InnerClassAccessMap.instance();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        LockChecker lockChecker = classContext.getLockChecker(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        boolean isGetterMethod = FindInconsistentSync2.isGetterMethod(classContext, method);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("**** Analyzing method ").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).toString());
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            try {
                TypeDataflow typeDataflow;
                TypeFrame typeFrame;
                Type instanceType;
                boolean isLocked;
                ValueNumberFrame frame;
                INVOKESTATIC inv;
                InnerClassAccess access;
                Instruction ins = location.getHandle().getInstruction();
                XField xfield = null;
                boolean isWrite = false;
                boolean isLocal = false;
                if (ins instanceof FieldInstruction) {
                    FieldInstruction fins = (FieldInstruction)ins;
                    xfield = Hierarchy.findXField((FieldInstruction)fins, (ConstantPoolGen)cpg);
                    isWrite = ins.getOpcode() == 181;
                    isLocal = fins.getClassName(cpg).equals(classContext.getJavaClass().getClassName());
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Handling field access: ").append(location.getHandle()).append(" (frame=").append(vnaDataflow.getFactAtLocation(location)).append(")").toString());
                    }
                } else if (ins instanceof INVOKESTATIC && (access = icam.getInnerClassAccess(inv = (INVOKESTATIC)ins, cpg)) != null && access.getMethodSignature().equals(inv.getSignature(cpg))) {
                    xfield = access.getField();
                    isWrite = !access.isLoad();
                    isLocal = false;
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Handling inner class access: ").append(location.getHandle()).append(" (frame=").append(vnaDataflow.getFactAtLocation(location)).append(")").toString());
                    }
                }
                if (xfield == null || xfield.isStatic() || xfield.isPublic() || xfield.isVolatile() || xfield.isFinal() || !(frame = vnaDataflow.getFactAtLocation(location)).isValid()) continue;
                ValueNumber thisValue = !method.isStatic() ? ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getThisValue() : null;
                LockSet lockSet = lockChecker.getFactAtLocation(location);
                InstructionHandle handle = location.getHandle();
                ValueNumber instance = (ValueNumber)frame.getInstance(handle.getInstruction(), cpg);
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Lock set: ").append(lockSet).toString());
                    System.out.println(new StringBuffer().append("value number: ").append(instance.getNumber()).toString());
                    System.out.println(new StringBuffer().append("Lock count: ").append(lockSet.getLockCount(instance.getNumber())).toString());
                }
                boolean isExplicitlyLocked = lockSet.getLockCount(instance.getNumber()) > 0;
                boolean isAccessedThroughThis = thisValue != null && thisValue.equals(instance);
                boolean bl = isLocked = isExplicitlyLocked || lockedMethodSet.contains(method) && isAccessedThroughThis || lockSet.containsReturnValue(((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactory());
                if (ADJUST_SUBCLASS_ACCESSES && (instanceType = (Type)(typeFrame = (typeDataflow = classContext.getTypeDataflow(method)).getFactAtLocation(location)).getInstance(handle.getInstruction(), cpg)) != TypeFrame.getNullType()) {
                    if (!(instanceType instanceof ObjectType)) {
                        throw new DataflowAnalysisException(new StringBuffer().append("Field accessed through non-object reference ").append(instanceType).toString(), methodGen, handle);
                    }
                    ObjectType objType = (ObjectType)instanceType;
                    String instanceClassName = objType.getClassName();
                    if (!instanceClassName.equals(xfield.getClassName())) {
                        xfield = new InstanceField(instanceClassName, xfield.getName(), xfield.getSignature(), xfield.getAccessFlags());
                    }
                }
                int kind = 0;
                kind |= isLocked ? 1 : 0;
                kind |= isWrite ? 2 : 0;
                if (!isLocked && FindInconsistentSync2.isConstructor(method.getName())) continue;
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("IS2:\t").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).append("\t").append(xfield).append("\t").append(isWrite ? "W" : "R").append("/").append(isLocked ? "L" : "U").toString());
                }
                FieldStats stats = this.getStats(xfield);
                stats.addAccess(kind);
                if (isExplicitlyLocked && isLocal) {
                    stats.addLocalLock();
                }
                if (isGetterMethod && !isLocked) {
                    stats.addGetterMethodAccess();
                }
                stats.addAccess(classContext, method, handle, isLocked);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    public static boolean isGetterMethod(ClassContext classContext, Method method) {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return false;
        }
        InstructionList il = methodGen.getInstructionList();
        if (il.getLength() > 60) {
            return false;
        }
        int count = 0;
        for (InstructionHandle ih : il) {
            switch (ih.getInstruction().getOpcode()) {
                case 180: {
                    if (++count <= 1) break;
                    return false;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 179: 
                case 181: {
                    return false;
                }
            }
        }
        return true;
    }

    private FieldStats getStats(XField field) {
        FieldStats stats = this.statMap.get(field);
        if (stats == null) {
            stats = new FieldStats();
            this.statMap.put(field, stats);
        }
        return stats;
    }

    private Set<Method> findNotUnlockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        lockedMethodSet.addAll(Arrays.asList(methodList));
        for (Method method : methodList) {
            if (!method.isPublic() || FindInconsistentSync2.isConstructor(method.getName())) continue;
            lockedMethodSet.remove(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (obviouslyLockedSites.contains(callSite) || lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.remove((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently not unlocked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return lockedMethodSet;
    }

    private Set<Method> findLockedMethods(ClassContext classContext, SelfCalls selfCalls, Set<CallSite> obviouslyLockedSites) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> lockedMethodSet = new HashSet<Method>();
        for (Method method : methodList) {
            if (!method.isSynchronized()) continue;
            lockedMethodSet.add(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (!obviouslyLockedSites.contains(callSite) && !lockedMethodSet.contains(callSite.getMethod()) || !lockedMethodSet.add((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Apparently locked methods:");
            for (Method method : lockedMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return lockedMethodSet;
    }

    private Set<Method> findPublicReachableMethods(ClassContext classContext, SelfCalls selfCalls) throws CFGBuilderException, DataflowAnalysisException {
        boolean change;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        CallGraph callGraph = selfCalls.getCallGraph();
        HashSet<Method> publicReachableMethodSet = new HashSet<Method>();
        for (Method method : methodList) {
            if (!method.isPublic() || FindInconsistentSync2.isConstructor(method.getName())) continue;
            publicReachableMethodSet.add(method);
        }
        do {
            change = false;
            Iterator i = callGraph.edgeIterator();
            while (i.hasNext()) {
                CallGraphNode target;
                CallGraphEdge edge = (CallGraphEdge)i.next();
                CallSite callSite = edge.getCallSite();
                if (!publicReachableMethodSet.contains(callSite.getMethod()) || !publicReachableMethodSet.add((target = (CallGraphNode)edge.getTarget()).getMethod())) continue;
                change = true;
            }
        } while (change);
        if (DEBUG) {
            System.out.println("Methods apparently reachable from public non-constructor methods:");
            for (Method method : publicReachableMethodSet) {
                System.out.println(new StringBuffer().append("\t").append(method.getName()).toString());
            }
        }
        return publicReachableMethodSet;
    }

    private Set<CallSite> findObviouslyLockedCallSites(ClassContext classContext, SelfCalls selfCalls) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        HashSet<CallSite> obviouslyLockedSites = new HashSet<CallSite>();
        Iterator i = selfCalls.callSiteIterator();
        while (i.hasNext()) {
            CallSite callSite = (CallSite)i.next();
            Method method = callSite.getMethod();
            Location location = callSite.getLocation();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (ins.getOpcode() == 184) continue;
            LockChecker lockChecker = classContext.getLockChecker(method);
            LockSet lockSet = lockChecker.getFactAtLocation(location);
            ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
            ValueNumberFrame frame = vnaDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            int numConsumed = ins.consumeStack(cpg);
            MethodGen methodGen = classContext.getMethodGen(method);
            if (!$assertionsDisabled && methodGen == null) {
                throw new AssertionError();
            }
            if (numConsumed == -2) {
                throw new DataflowAnalysisException("Unpredictable stack consumption", methodGen, handle);
            }
            ValueNumber instance = (ValueNumber)frame.getStackValue(numConsumed - 1);
            int lockCount = lockSet.getLockCount(instance.getNumber());
            if (lockCount <= 0) continue;
            obviouslyLockedSites.add(callSite);
        }
        return obviouslyLockedSites;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$detect$FindInconsistentSync2 == null ? (class$edu$umd$cs$findbugs$detect$FindInconsistentSync2 = FindInconsistentSync2.class$("edu.umd.cs.findbugs.detect.FindInconsistentSync2")) : class$edu$umd$cs$findbugs$detect$FindInconsistentSync2).desiredAssertionStatus();
        DEBUG = Boolean.getBoolean("fis.debug");
        ADJUST_SUBCLASS_ACCESSES = !Boolean.getBoolean("fis.noAdjustSubclass");
        EVAL = Boolean.getBoolean("fis.eval");
        MIN_SYNC_PERCENT = Integer.getInteger("findbugs.fis.minSyncPercent", 50);
        WRITE_BIAS = Double.parseDouble(System.getProperty("findbugs.fis.writeBias", "2.0"));
        UNSYNC_FACTOR = Double.parseDouble(System.getProperty("findbugs.fis.unsyncFactor", "2.0"));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldStats {
        private int[] countList = new int[4];
        private int numLocalLocks = 0;
        private int numGetterMethodAccesses = 0;
        private LinkedList<SourceLineAnnotation> unsyncAccessList = new LinkedList();
        private LinkedList<SourceLineAnnotation> syncAccessList = new LinkedList();

        private FieldStats() {
        }

        public void addAccess(int kind) {
            int n = kind;
            this.countList[n] = this.countList[n] + 1;
        }

        public int getNumAccesses(int kind) {
            return this.countList[kind];
        }

        public void addLocalLock() {
            ++this.numLocalLocks;
        }

        public int getNumLocalLocks() {
            return this.numLocalLocks;
        }

        public void addGetterMethodAccess() {
            ++this.numGetterMethodAccesses;
        }

        public int getNumGetterMethodAccesses() {
            return this.numGetterMethodAccesses;
        }

        public void addAccess(ClassContext classContext, Method method, InstructionHandle handle, boolean isLocked) {
            JavaClass javaClass = classContext.getJavaClass();
            String sourceFile = javaClass.getSourceFileName();
            MethodGen methodGen = classContext.getMethodGen(method);
            SourceLineAnnotation accessSourceLine = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)sourceFile, (InstructionHandle)handle);
            if (accessSourceLine != null) {
                (isLocked ? this.syncAccessList : this.unsyncAccessList).add(accessSourceLine);
            }
        }

        public Iterator<SourceLineAnnotation> unsyncAccessIterator() {
            return this.unsyncAccessList.iterator();
        }

        public Iterator<SourceLineAnnotation> syncAccessIterator() {
            return this.syncAccessList.iterator();
        }
    }
}

