/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.Address;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Municipality;
import fi.metatavu.kuntaapi.server.rest.model.Phone;
import fi.metatavu.kuntaapi.server.rest.model.ServiceHour;
import fi.metatavu.kuntaapi.server.rest.model.WebPage;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ServiceLocationServiceChannel {
    private String id = null;
    private String organizationId = null;
    private List<LocalizedValue> names = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> descriptions = new ArrayList<LocalizedValue>();
    private Boolean serviceAreaRestricted = null;
    private List<Phone> phoneNumbers = new ArrayList<Phone>();
    private List<LocalizedValue> emails = new ArrayList<LocalizedValue>();
    private List<String> languages = new ArrayList<String>();
    private Boolean phoneServiceCharge = null;
    private List<WebPage> webPages = new ArrayList<WebPage>();
    private List<Municipality> serviceAreas = new ArrayList<Municipality>();
    private List<Address> addresses = new ArrayList<Address>();
    private List<ServiceHour> serviceHours = new ArrayList<ServiceHour>();
    private String publishingStatus = null;

    public ServiceLocationServiceChannel id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier for the service channel.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ServiceLocationServiceChannel organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization identifier responsible for the channel.")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public ServiceLocationServiceChannel names(List<LocalizedValue> names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of service channel names.")
    public List<LocalizedValue> getNames() {
        return this.names;
    }

    public void setNames(List<LocalizedValue> names) {
        this.names = names;
    }

    public ServiceLocationServiceChannel descriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized service channel descriptions.")
    public List<LocalizedValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
    }

    public ServiceLocationServiceChannel serviceAreaRestricted(Boolean serviceAreaRestricted) {
        this.serviceAreaRestricted = serviceAreaRestricted;
        return this;
    }

    @ApiModelProperty(example="null", value="Is the service location channel restricted by service area.")
    public Boolean getServiceAreaRestricted() {
        return this.serviceAreaRestricted;
    }

    public void setServiceAreaRestricted(Boolean serviceAreaRestricted) {
        this.serviceAreaRestricted = serviceAreaRestricted;
    }

    public ServiceLocationServiceChannel phoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of phone numbers for the service channel. Includes also fax numbers.")
    public List<Phone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<Phone> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ServiceLocationServiceChannel emails(List<LocalizedValue> emails) {
        this.emails = emails;
        return this;
    }

    @ApiModelProperty(example="null", value="List email addresses for the service channel.")
    public List<LocalizedValue> getEmails() {
        return this.emails;
    }

    public void setEmails(List<LocalizedValue> emails) {
        this.emails = emails;
    }

    public ServiceLocationServiceChannel languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of languages the service channel is available in (two letter language code).")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public ServiceLocationServiceChannel phoneServiceCharge(Boolean phoneServiceCharge) {
        this.phoneServiceCharge = phoneServiceCharge;
        return this;
    }

    @ApiModelProperty(example="null", value="Is the phone service charged for.")
    public Boolean getPhoneServiceCharge() {
        return this.phoneServiceCharge;
    }

    public void setPhoneServiceCharge(Boolean phoneServiceCharge) {
        this.phoneServiceCharge = phoneServiceCharge;
    }

    public ServiceLocationServiceChannel webPages(List<WebPage> webPages) {
        this.webPages = webPages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel web pages.")
    public List<WebPage> getWebPages() {
        return this.webPages;
    }

    public void setWebPages(List<WebPage> webPages) {
        this.webPages = webPages;
    }

    public ServiceLocationServiceChannel serviceAreas(List<Municipality> serviceAreas) {
        this.serviceAreas = serviceAreas;
        return this;
    }

    @ApiModelProperty(example="null", value="List of serviceareas. Used when location service channel is restricted by service area (ServiceAreaRestricted=true).")
    public List<Municipality> getServiceAreas() {
        return this.serviceAreas;
    }

    public void setServiceAreas(List<Municipality> serviceAreas) {
        this.serviceAreas = serviceAreas;
    }

    public ServiceLocationServiceChannel addresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service location addresses.")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public ServiceLocationServiceChannel serviceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel service hours.")
    public List<ServiceHour> getServiceHours() {
        return this.serviceHours;
    }

    public void setServiceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
    }

    public ServiceLocationServiceChannel publishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Service channel publishing status. Values: Draft, Published, Deleted, Modified or OldPublished.")
    public String getPublishingStatus() {
        return this.publishingStatus;
    }

    public void setPublishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLocationServiceChannel serviceLocationServiceChannel = (ServiceLocationServiceChannel)o;
        return Objects.equals(this.id, serviceLocationServiceChannel.id) && Objects.equals(this.organizationId, serviceLocationServiceChannel.organizationId) && Objects.equals(this.names, serviceLocationServiceChannel.names) && Objects.equals(this.descriptions, serviceLocationServiceChannel.descriptions) && Objects.equals(this.serviceAreaRestricted, serviceLocationServiceChannel.serviceAreaRestricted) && Objects.equals(this.phoneNumbers, serviceLocationServiceChannel.phoneNumbers) && Objects.equals(this.emails, serviceLocationServiceChannel.emails) && Objects.equals(this.languages, serviceLocationServiceChannel.languages) && Objects.equals(this.phoneServiceCharge, serviceLocationServiceChannel.phoneServiceCharge) && Objects.equals(this.webPages, serviceLocationServiceChannel.webPages) && Objects.equals(this.serviceAreas, serviceLocationServiceChannel.serviceAreas) && Objects.equals(this.addresses, serviceLocationServiceChannel.addresses) && Objects.equals(this.serviceHours, serviceLocationServiceChannel.serviceHours) && Objects.equals(this.publishingStatus, serviceLocationServiceChannel.publishingStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organizationId, this.names, this.descriptions, this.serviceAreaRestricted, this.phoneNumbers, this.emails, this.languages, this.phoneServiceCharge, this.webPages, this.serviceAreas, this.addresses, this.serviceHours, this.publishingStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLocationServiceChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    serviceAreaRestricted: ").append(this.toIndentedString(this.serviceAreaRestricted)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    phoneServiceCharge: ").append(this.toIndentedString(this.phoneServiceCharge)).append("\n");
        sb.append("    webPages: ").append(this.toIndentedString(this.webPages)).append("\n");
        sb.append("    serviceAreas: ").append(this.toIndentedString(this.serviceAreas)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    serviceHours: ").append(this.toIndentedString(this.serviceHours)).append("\n");
        sb.append("    publishingStatus: ").append(this.toIndentedString(this.publishingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

