/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.Address;
import fi.metatavu.kuntaapi.server.rest.model.Attachment;
import fi.metatavu.kuntaapi.server.rest.model.Email;
import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Phone;
import fi.metatavu.kuntaapi.server.rest.model.ServiceHour;
import fi.metatavu.kuntaapi.server.rest.model.WebPage;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PrintableFormServiceChannel {
    private String id = null;
    private String organizationId = null;
    private List<LocalizedValue> names = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> descriptions = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> formIdentifier = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> formReceiver = new ArrayList<LocalizedValue>();
    private Address deliveryAddress = null;
    private List<LocalizedValue> channelUrls = new ArrayList<LocalizedValue>();
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Phone> supportPhones = new ArrayList<Phone>();
    private List<Email> supportEmails = new ArrayList<Email>();
    private List<String> languages = new ArrayList<String>();
    private List<WebPage> webPages = new ArrayList<WebPage>();
    private List<ServiceHour> serviceHours = new ArrayList<ServiceHour>();
    private String publishingStatus = null;

    public PrintableFormServiceChannel id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier for the service channel.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PrintableFormServiceChannel organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization identifier responsible for the channel.")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public PrintableFormServiceChannel names(List<LocalizedValue> names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of service channel names.")
    public List<LocalizedValue> getNames() {
        return this.names;
    }

    public void setNames(List<LocalizedValue> names) {
        this.names = names;
    }

    public PrintableFormServiceChannel descriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized service channel descriptions.")
    public List<LocalizedValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocalizedValue> descriptions) {
        this.descriptions = descriptions;
    }

    public PrintableFormServiceChannel formIdentifier(List<LocalizedValue> formIdentifier) {
        this.formIdentifier = formIdentifier;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized form identifier. One per language.")
    public List<LocalizedValue> getFormIdentifier() {
        return this.formIdentifier;
    }

    public void setFormIdentifier(List<LocalizedValue> formIdentifier) {
        this.formIdentifier = formIdentifier;
    }

    public PrintableFormServiceChannel formReceiver(List<LocalizedValue> formReceiver) {
        this.formReceiver = formReceiver;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized form receiver. One per language.")
    public List<LocalizedValue> getFormReceiver() {
        return this.formReceiver;
    }

    public void setFormReceiver(List<LocalizedValue> formReceiver) {
        this.formReceiver = formReceiver;
    }

    public PrintableFormServiceChannel deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Form delivery address.")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PrintableFormServiceChannel channelUrls(List<LocalizedValue> channelUrls) {
        this.channelUrls = channelUrls;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized channel urls.")
    public List<LocalizedValue> getChannelUrls() {
        return this.channelUrls;
    }

    public void setChannelUrls(List<LocalizedValue> channelUrls) {
        this.channelUrls = channelUrls;
    }

    public PrintableFormServiceChannel attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of attachments.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public PrintableFormServiceChannel supportPhones(List<Phone> supportPhones) {
        this.supportPhones = supportPhones;
        return this;
    }

    @ApiModelProperty(example="null", value="List of support phone numbers for the service channel.")
    public List<Phone> getSupportPhones() {
        return this.supportPhones;
    }

    public void setSupportPhones(List<Phone> supportPhones) {
        this.supportPhones = supportPhones;
    }

    public PrintableFormServiceChannel supportEmails(List<Email> supportEmails) {
        this.supportEmails = supportEmails;
        return this;
    }

    @ApiModelProperty(example="null", value="List of support email addresses for the service channel.")
    public List<Email> getSupportEmails() {
        return this.supportEmails;
    }

    public void setSupportEmails(List<Email> supportEmails) {
        this.supportEmails = supportEmails;
    }

    public PrintableFormServiceChannel languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of languages the service channel is available in (two letter language code).")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public PrintableFormServiceChannel webPages(List<WebPage> webPages) {
        this.webPages = webPages;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel web pages.")
    public List<WebPage> getWebPages() {
        return this.webPages;
    }

    public void setWebPages(List<WebPage> webPages) {
        this.webPages = webPages;
    }

    public PrintableFormServiceChannel serviceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
        return this;
    }

    @ApiModelProperty(example="null", value="List of service channel service hours.")
    public List<ServiceHour> getServiceHours() {
        return this.serviceHours;
    }

    public void setServiceHours(List<ServiceHour> serviceHours) {
        this.serviceHours = serviceHours;
    }

    public PrintableFormServiceChannel publishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Service channel publishing status. Values: Draft, Published, Deleted, Modified or OldPublished.")
    public String getPublishingStatus() {
        return this.publishingStatus;
    }

    public void setPublishingStatus(String publishingStatus) {
        this.publishingStatus = publishingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrintableFormServiceChannel printableFormServiceChannel = (PrintableFormServiceChannel)o;
        return Objects.equals(this.id, printableFormServiceChannel.id) && Objects.equals(this.organizationId, printableFormServiceChannel.organizationId) && Objects.equals(this.names, printableFormServiceChannel.names) && Objects.equals(this.descriptions, printableFormServiceChannel.descriptions) && Objects.equals(this.formIdentifier, printableFormServiceChannel.formIdentifier) && Objects.equals(this.formReceiver, printableFormServiceChannel.formReceiver) && Objects.equals(this.deliveryAddress, printableFormServiceChannel.deliveryAddress) && Objects.equals(this.channelUrls, printableFormServiceChannel.channelUrls) && Objects.equals(this.attachments, printableFormServiceChannel.attachments) && Objects.equals(this.supportPhones, printableFormServiceChannel.supportPhones) && Objects.equals(this.supportEmails, printableFormServiceChannel.supportEmails) && Objects.equals(this.languages, printableFormServiceChannel.languages) && Objects.equals(this.webPages, printableFormServiceChannel.webPages) && Objects.equals(this.serviceHours, printableFormServiceChannel.serviceHours) && Objects.equals(this.publishingStatus, printableFormServiceChannel.publishingStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organizationId, this.names, this.descriptions, this.formIdentifier, this.formReceiver, this.deliveryAddress, this.channelUrls, this.attachments, this.supportPhones, this.supportEmails, this.languages, this.webPages, this.serviceHours, this.publishingStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrintableFormServiceChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    formIdentifier: ").append(this.toIndentedString(this.formIdentifier)).append("\n");
        sb.append("    formReceiver: ").append(this.toIndentedString(this.formReceiver)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    channelUrls: ").append(this.toIndentedString(this.channelUrls)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    supportPhones: ").append(this.toIndentedString(this.supportPhones)).append("\n");
        sb.append("    supportEmails: ").append(this.toIndentedString(this.supportEmails)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    webPages: ").append(this.toIndentedString(this.webPages)).append("\n");
        sb.append("    serviceHours: ").append(this.toIndentedString(this.serviceHours)).append("\n");
        sb.append("    publishingStatus: ").append(this.toIndentedString(this.publishingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

