package fi.metatavu.kuntaapi.server.rest.model;

import java.time.LocalDate;



import io.swagger.annotations.*;
import java.util.Objects;


public class ScheduleException   {
  
  private String type = null;
  private LocalDate date = null;

  /**
   **/
  public ScheduleException type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(example = "null", value = "")
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public ScheduleException date(LocalDate date) {
    this.date = date;
    return this;
  }

  
  @ApiModelProperty(example = "null", value = "")
  public LocalDate getDate() {
    return date;
  }
  public void setDate(LocalDate date) {
    this.date = date;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleException scheduleException = (ScheduleException) o;
    return Objects.equals(type, scheduleException.type) &&
        Objects.equals(date, scheduleException.date);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, date);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleException {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
