/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest;

import fi.metatavu.kuntaapi.server.rest.AbstractApi;
import fi.metatavu.kuntaapi.server.rest.model.ElectronicChannel;
import fi.metatavu.kuntaapi.server.rest.model.PhoneChannel;
import fi.metatavu.kuntaapi.server.rest.model.PrintableFormChannel;
import fi.metatavu.kuntaapi.server.rest.model.Service;
import fi.metatavu.kuntaapi.server.rest.model.ServiceLocationChannel;
import fi.metatavu.kuntaapi.server.rest.model.WebPageChannel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/services")
@Api(description="the services API")
@Consumes(value={"application/json;charset=utf-8"})
@Produces(value={"application/json;charset=utf-8"})
public abstract class ServicesApi
extends AbstractApi {
    @POST
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Create service", notes="Creates new service", response=Service.class, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Created service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response createService(Service var1, @Context Request var2);

    @POST
    @Path(value="/{serviceId}/electronicChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="creates ElectronicChannel", notes="creates ElectronicChannel", response=ElectronicChannel.class, tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns created ElectronicChannel", response=ElectronicChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicChannel.class)})
    public abstract Response createServiceElectronicChannel(@PathParam(value="serviceId") String var1, ElectronicChannel var2, @Context Request var3);

    @POST
    @Path(value="/{serviceId}/phoneChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="creates PhoneChannel", notes="creates PhoneChannel", response=PhoneChannel.class, tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns created PhoneChannel", response=PhoneChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneChannel.class)})
    public abstract Response createServicePhoneChannel(@PathParam(value="serviceId") String var1, PhoneChannel var2, @Context Request var3);

    @POST
    @Path(value="/{serviceId}/printableFormChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="creates PrintableFormChannel", notes="creates PrintableFormChannel", response=PrintableFormChannel.class, tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns created PrintableFormChannel", response=PrintableFormChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormChannel.class), @ApiResponse(code=500, message="Internal server error", response=PrintableFormChannel.class)})
    public abstract Response createServicePrintableFormChannel(@PathParam(value="serviceId") String var1, PrintableFormChannel var2, @Context Request var3);

    @POST
    @Path(value="/{serviceId}/serviceLocationChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="creates ServiceLocationChannel", notes="creates ServiceLocationChannel", response=ServiceLocationChannel.class, tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns created ServiceLocationChannel", response=ServiceLocationChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationChannel.class), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationChannel.class)})
    public abstract Response createServiceServiceLocationChannel(@PathParam(value="serviceId") String var1, ServiceLocationChannel var2, @Context Request var3);

    @POST
    @Path(value="/{serviceId}/webPageChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="creates WebPageChannel", notes="creates WebPageChannel", response=WebPageChannel.class, tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns created WebPageChannel", response=WebPageChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageChannel.class), @ApiResponse(code=500, message="Internal server error", response=WebPageChannel.class)})
    public abstract Response createServiceWebPageChannel(@PathParam(value="serviceId") String var1, WebPageChannel var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds a service by id", notes="Finds service", response=Service.class, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response findService(@PathParam(value="serviceId") String var1, @Context Request var2);

    @GET
    @Path(value="/{serviceId}/electronicChannels/{electronicChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds ElectronicChannel by electronicChannelId", notes="finds ElectronicChannels by electronicChannelId", response=ElectronicChannel.class, tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns ElectronicChannel", response=ElectronicChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicChannel.class)})
    public abstract Response findServiceElectronicChannel(@PathParam(value="serviceId") String var1, @PathParam(value="electronicChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/phoneChannels/{phoneChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds PhoneChannel by phoneChannelId", notes="finds PhoneChannels by phoneChannelId", response=PhoneChannel.class, tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns PhoneChannel", response=PhoneChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneChannel.class)})
    public abstract Response findServicePhoneChannel(@PathParam(value="serviceId") String var1, @PathParam(value="phoneChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/printableFormChannels/{printableFormChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds PrintableFormChannel by printableFormChannelId", notes="finds PrintableFormChannels by printableFormChannelId", response=PrintableFormChannel.class, tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns PrintableFormChannel", response=PrintableFormChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormChannel.class), @ApiResponse(code=500, message="Internal server error", response=PrintableFormChannel.class)})
    public abstract Response findServicePrintableFormChannel(@PathParam(value="serviceId") String var1, @PathParam(value="printableFormChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/serviceLocationChannels/{serviceLocationChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds ServiceLocationChannel by serviceLocationChannelId", notes="finds ServiceLocationChannels by serviceLocationChannelId", response=ServiceLocationChannel.class, tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns ServiceLocationChannel", response=ServiceLocationChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationChannel.class), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationChannel.class)})
    public abstract Response findServiceServiceLocationChannel(@PathParam(value="serviceId") String var1, @PathParam(value="serviceLocationChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/webPageChannels/{webPageChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds WebPageChannel by webPageChannelId", notes="finds WebPageChannels by webPageChannelId", response=WebPageChannel.class, tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns WebPageChannel", response=WebPageChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageChannel.class), @ApiResponse(code=500, message="Internal server error", response=WebPageChannel.class)})
    public abstract Response findServiceWebPageChannel(@PathParam(value="serviceId") String var1, @PathParam(value="webPageChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/electronicChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists ElectronicChannels by serviceId", notes="Lists ElectronicChannels by serviceId", response=ElectronicChannel.class, responseContainer="List", tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of ElectronicChannels", response=ElectronicChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=ElectronicChannel.class, responseContainer="List")})
    public abstract Response listServiceElectronicChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/phoneChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists PhoneChannels by serviceId", notes="Lists PhoneChannels by serviceId", response=PhoneChannel.class, responseContainer="List", tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of PhoneChannels", response=PhoneChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=PhoneChannel.class, responseContainer="List")})
    public abstract Response listServicePhoneChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/printableFormChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists PrintableFormChannels by serviceId", notes="Lists PrintableFormChannels by serviceId", response=PrintableFormChannel.class, responseContainer="List", tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of PrintableFormChannels", response=PrintableFormChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=PrintableFormChannel.class, responseContainer="List")})
    public abstract Response listServicePrintableFormChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/serviceLocationChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists ServiceLocationChannels by serviceId", notes="Lists ServiceLocationChannels by serviceId", response=ServiceLocationChannel.class, responseContainer="List", tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of ServiceLocationChannels", response=ServiceLocationChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationChannel.class, responseContainer="List")})
    public abstract Response listServiceServiceLocationChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/webPageChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists WebPageChannels by serviceId", notes="Lists WebPageChannels by serviceId", response=WebPageChannel.class, responseContainer="List", tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of WebPageChannels", response=WebPageChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=WebPageChannel.class, responseContainer="List")})
    public abstract Response listServiceWebPageChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Service list", notes="Lists services", response=Service.class, responseContainer="List", tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of services", response=Service.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Service.class, responseContainer="List")})
    public abstract Response listServices(@QueryParam(value="organizationId") String var1, @QueryParam(value="search") String var2, @QueryParam(value="firstResult") Long var3, @QueryParam(value="maxResults") Long var4, @Context Request var5);

    @PUT
    @Path(value="/{serviceId}/phoneChannels/{phoneChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates PhoneChannel", notes="Updates PhoneChannel", response=PhoneChannel.class, tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns updated PhoneChannel", response=PhoneChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneChannel.class)})
    public abstract Response updatePhoneChannel(@PathParam(value="serviceId") String var1, @PathParam(value="phoneChannelId") String var2, PhoneChannel var3, @Context Request var4);

    @PUT
    @Path(value="/{serviceId}/printableFormChannels/{printableFormChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates PrintableFormChannel", notes="Updates PrintableFormChannel", response=PrintableFormChannel.class, tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns updated PrintableFormChannel", response=PrintableFormChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormChannel.class), @ApiResponse(code=500, message="Internal server error", response=PrintableFormChannel.class)})
    public abstract Response updatePrintableFormChannel(@PathParam(value="serviceId") String var1, @PathParam(value="printableFormChannelId") String var2, PrintableFormChannel var3, @Context Request var4);

    @PUT
    @Path(value="/{serviceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates service", notes="Updates service", response=Service.class, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an updated service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response updateService(@PathParam(value="serviceId") String var1, Service var2, @Context Request var3);

    @PUT
    @Path(value="/{serviceId}/electronicChannels/{electronicChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates ElectronicChannel", notes="Updates ElectronicChannel", response=ElectronicChannel.class, tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns updated ElectronicChannel", response=ElectronicChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicChannel.class)})
    public abstract Response updateServiceElectronicChannel(@PathParam(value="serviceId") String var1, @PathParam(value="electronicChannelId") String var2, ElectronicChannel var3, @Context Request var4);

    @PUT
    @Path(value="/{serviceId}/serviceLocationChannels/{serviceLocationChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates ServiceLocationChannel", notes="Updates ServiceLocationChannel", response=ServiceLocationChannel.class, tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns updated ServiceLocationChannel", response=ServiceLocationChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationChannel.class), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationChannel.class)})
    public abstract Response updateServiceLocationChannel(@PathParam(value="serviceId") String var1, @PathParam(value="serviceLocationChannelId") String var2, ServiceLocationChannel var3, @Context Request var4);

    @PUT
    @Path(value="/{serviceId}/webPageChannels/{webPageChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates WebPageChannel", notes="Updates WebPageChannel", response=WebPageChannel.class, tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns updated WebPageChannel", response=WebPageChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageChannel.class), @ApiResponse(code=500, message="Internal server error", response=WebPageChannel.class)})
    public abstract Response updateWebPageChannel(@PathParam(value="serviceId") String var1, @PathParam(value="webPageChannelId") String var2, WebPageChannel var3, @Context Request var4);
}

