/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest;

import fi.metatavu.kuntaapi.server.rest.AbstractApi;
import fi.metatavu.kuntaapi.server.rest.model.ElectronicServiceChannel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/electronicServiceChannels")
@Api(description="the electronicServiceChannels API")
@Consumes(value={"application/json;charset=utf-8"})
@Produces(value={"application/json;charset=utf-8"})
public abstract class ElectronicServiceChannelsApi
extends AbstractApi {
    @GET
    @Path(value="/{electronicServiceChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds an electronic service channel by id", notes="Finds an electronic service channel by id", response=ElectronicServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "ElectronicServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an electronic service channel by id", response=ElectronicServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicServiceChannel.class)})
    public abstract Response findElectronicServiceChannel(@PathParam(value="electronicServiceChannelId") String var1, @Context Request var2);

    @GET
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists electronic service channels", notes="Lists electronic service channels", response=ElectronicServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "ElectronicServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of electronic service channels", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=ElectronicServiceChannel.class, responseContainer="List")})
    public abstract Response listElectronicServiceChannels(@QueryParam(value="organizationId") String var1, @QueryParam(value="search") String var2, @QueryParam(value="sortBy") String var3, @QueryParam(value="sortDir") String var4, @QueryParam(value="firstResult") Long var5, @QueryParam(value="maxResults") Long var6, @Context Request var7);

    @PUT
    @Path(value="/{electronicServiceChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates a channel", notes="Updates a service channel", response=ElectronicServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "ElectronicServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a service location service channel", response=ElectronicServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicServiceChannel.class)})
    public abstract Response updateElectronicServiceChannel(@PathParam(value="electronicServiceChannelId") String var1, ElectronicServiceChannel var2, @Context Request var3);
}

