/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest;

import fi.metatavu.kuntaapi.server.rest.AbstractApi;
import fi.metatavu.kuntaapi.server.rest.model.PhoneServiceChannel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/phoneServiceChannels")
@Api(description="the phoneServiceChannels API")
@Consumes(value={"application/json;charset=utf-8"})
@Produces(value={"application/json;charset=utf-8"})
public abstract class PhoneServiceChannelsApi
extends AbstractApi {
    @GET
    @Path(value="/{phoneServiceChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds a phone service channel by id", notes="Finds a phone service channel by id", response=PhoneServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "PhoneServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a phone service channel", response=PhoneServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneServiceChannel.class)})
    public abstract Response findPhoneServiceChannel(@PathParam(value="phoneServiceChannelId") String var1, @Context Request var2);

    @GET
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists phone service channels", notes="Lists phone service channels", response=PhoneServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "PhoneServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of phone service channels", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=PhoneServiceChannel.class, responseContainer="List")})
    public abstract Response listPhoneServiceChannels(@QueryParam(value="organizationId") String var1, @QueryParam(value="search") String var2, @QueryParam(value="sortBy") String var3, @QueryParam(value="sortDir") String var4, @QueryParam(value="firstResult") Long var5, @QueryParam(value="maxResults") Long var6, @Context Request var7);

    @PUT
    @Path(value="/{phoneServiceChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates a channel", notes="Updates a service channel", response=PhoneServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"ServiceChannels", "PhoneServiceChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a phone service channel", response=PhoneServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneServiceChannel.class)})
    public abstract Response updatePhoneServiceChannel(@PathParam(value="phoneServiceChannelId") String var1, PhoneServiceChannel var2, @Context Request var3);
}

