/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest.model;

import fi.metatavu.kuntaapi.server.rest.model.LocalizedValue;
import fi.metatavu.kuntaapi.server.rest.model.Municipality;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Address {
    private String latitude = null;
    private String longitude = null;
    private String coordinateState = null;
    private String type = null;
    private String subtype = null;
    private List<LocalizedValue> postOfficeBox = new ArrayList<LocalizedValue>();
    private String postalCode = null;
    private List<LocalizedValue> postOffice = new ArrayList<LocalizedValue>();
    private List<LocalizedValue> streetAddress = new ArrayList<LocalizedValue>();
    private String streetNumber = null;
    private Municipality municipality = null;
    private String country = null;
    private List<LocalizedValue> locationAbroad = new ArrayList<LocalizedValue>();
    private List<Address> multipointLocation = new ArrayList<Address>();
    private List<LocalizedValue> additionalInformations = new ArrayList<LocalizedValue>();

    public Address latitude(String latitude) {
        this.latitude = latitude;
        return this;
    }

    @ApiModelProperty(example="null", value="Service location latitude coordinate.")
    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public Address longitude(String longitude) {
        this.longitude = longitude;
        return this;
    }

    @ApiModelProperty(example="null", value="Service location longitude coordinate.")
    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public Address coordinateState(String coordinateState) {
        this.coordinateState = coordinateState;
        return this;
    }

    @ApiModelProperty(example="null", value="State of coordinates. Coordinates are fetched from a service provided by Maanmittauslaitos (WFS).  Possible values are: Loading, Ok, Failed, NotReceived, EmptyInputReceived, MultipleResultsReceived or WrongFormatReceived.")
    public String getCoordinateState() {
        return this.coordinateState;
    }

    public void setCoordinateState(String coordinateState) {
        this.coordinateState = coordinateState;
    }

    public Address type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Address type, Visiting or Postal.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Address subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(example="null", value="Address sub type, Single, Street, PostOfficeBox, Abroad or Multipoint or NoAddress.")
    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public Address postOfficeBox(List<LocalizedValue> postOfficeBox) {
        this.postOfficeBox = postOfficeBox;
        return this;
    }

    @ApiModelProperty(example="null", value="Post office box like PL 310")
    public List<LocalizedValue> getPostOfficeBox() {
        return this.postOfficeBox;
    }

    public void setPostOfficeBox(List<LocalizedValue> postOfficeBox) {
        this.postOfficeBox = postOfficeBox;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Postal code, for example 00010.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address postOffice(List<LocalizedValue> postOffice) {
        this.postOffice = postOffice;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized Post offices, for example Helsinki, Helsingfors.")
    public List<LocalizedValue> getPostOffice() {
        return this.postOffice;
    }

    public void setPostOffice(List<LocalizedValue> postOffice) {
        this.postOffice = postOffice;
    }

    public Address streetAddress(List<LocalizedValue> streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="List of localized street addresses.")
    public List<LocalizedValue> getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(List<LocalizedValue> streetAddress) {
        this.streetAddress = streetAddress;
    }

    public Address streetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Street number for street address.")
    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public Address municipality(Municipality municipality) {
        this.municipality = municipality;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Municipality getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(Municipality municipality) {
        this.municipality = municipality;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="null", value="Country code (ISO 3166-1 alpha-2), for example FI.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Address locationAbroad(List<LocalizedValue> locationAbroad) {
        this.locationAbroad = locationAbroad;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of foreign address information.")
    public List<LocalizedValue> getLocationAbroad() {
        return this.locationAbroad;
    }

    public void setLocationAbroad(List<LocalizedValue> locationAbroad) {
        this.locationAbroad = locationAbroad;
    }

    public Address multipointLocation(List<Address> multipointLocation) {
        this.multipointLocation = multipointLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Moving address. Includes several street addresses.")
    public List<Address> getMultipointLocation() {
        return this.multipointLocation;
    }

    public void setMultipointLocation(List<Address> multipointLocation) {
        this.multipointLocation = multipointLocation;
    }

    public Address additionalInformations(List<LocalizedValue> additionalInformations) {
        this.additionalInformations = additionalInformations;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized list of additional information about the address.")
    public List<LocalizedValue> getAdditionalInformations() {
        return this.additionalInformations;
    }

    public void setAdditionalInformations(List<LocalizedValue> additionalInformations) {
        this.additionalInformations = additionalInformations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.latitude, address.latitude) && Objects.equals(this.longitude, address.longitude) && Objects.equals(this.coordinateState, address.coordinateState) && Objects.equals(this.type, address.type) && Objects.equals(this.subtype, address.subtype) && Objects.equals(this.postOfficeBox, address.postOfficeBox) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.postOffice, address.postOffice) && Objects.equals(this.streetAddress, address.streetAddress) && Objects.equals(this.streetNumber, address.streetNumber) && Objects.equals(this.municipality, address.municipality) && Objects.equals(this.country, address.country) && Objects.equals(this.locationAbroad, address.locationAbroad) && Objects.equals(this.multipointLocation, address.multipointLocation) && Objects.equals(this.additionalInformations, address.additionalInformations);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude, this.coordinateState, this.type, this.subtype, this.postOfficeBox, this.postalCode, this.postOffice, this.streetAddress, this.streetNumber, this.municipality, this.country, this.locationAbroad, this.multipointLocation, this.additionalInformations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("    coordinateState: ").append(this.toIndentedString(this.coordinateState)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    postOfficeBox: ").append(this.toIndentedString(this.postOfficeBox)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    postOffice: ").append(this.toIndentedString(this.postOffice)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    streetNumber: ").append(this.toIndentedString(this.streetNumber)).append("\n");
        sb.append("    municipality: ").append(this.toIndentedString(this.municipality)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    locationAbroad: ").append(this.toIndentedString(this.locationAbroad)).append("\n");
        sb.append("    multipointLocation: ").append(this.toIndentedString(this.multipointLocation)).append("\n");
        sb.append("    additionalInformations: ").append(this.toIndentedString(this.additionalInformations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

