/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.threadsafetyagent.util;

import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.ClassReader;
import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.ClassVisitor;
import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.ClassWriter;
import fi.jumi.threadsafetyagent.util.DoNotTransformException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

public abstract class AbstractTransformationChain
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = this.enableAdditiveTransformationOptimization() ? new ClassWriter(cr, 0) : new ClassWriter(0);
        try {
            ClassVisitor cv = this.getAdapters(cw);
            cr.accept(cv, 0);
            return cw.toByteArray();
        }
        catch (DoNotTransformException e) {
            return classfileBuffer;
        }
    }

    protected boolean enableAdditiveTransformationOptimization() {
        return true;
    }

    protected abstract ClassVisitor getAdapters(ClassVisitor var1);
}

