/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.threadsafetyagent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThreadSafetyChecker {
    private Thread lastThread = null;
    private final Set<Thread> calledFromThreads = new HashSet<Thread>(1, 1.0f);
    private CallLocation callLocations = null;

    public void checkCurrentThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.lastThread) {
            return;
        }
        this.lastThread = currentThread;
        this.fullCheck(currentThread);
    }

    private synchronized void fullCheck(Thread currentThread) {
        if (this.calledFromThreads.contains(currentThread)) {
            return;
        }
        this.calledFromThreads.add(currentThread);
        this.callLocations = new CallLocation(this.callLocations);
        if (this.calledFromThreads.size() > 1) {
            AssertionError e = new AssertionError("non-thread-safe instance called from multiple threads: " + ThreadSafetyChecker.threadNames(this.calledFromThreads)){

                public Throwable fillInStackTrace() {
                    return this;
                }
            };
            ((Throwable)((Object)e)).initCause(this.callLocations);
            throw e;
        }
    }

    private static String threadNames(Set<Thread> threads) {
        ArrayList<String> threadNames = new ArrayList<String>();
        for (Thread thread : threads) {
            threadNames.add(thread.getName());
        }
        Collections.sort(threadNames);
        String s = "";
        for (String threadName : threadNames) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + threadName;
        }
        return s;
    }

    private static class CallLocation
    extends RuntimeException {
        public CallLocation(CallLocation previousLocations) {
            super("called from thread: " + Thread.currentThread().getName(), previousLocations);
        }
    }
}

