/*
 * Decompiled with CFR 0.152.
 */
package fi.jumi.threadsafetyagent;

import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.ClassVisitor;
import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.FieldVisitor;
import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.Label;
import fi.jumi.threadsafetyagent.INTERNAL.org.objectweb.asm.MethodVisitor;
import fi.jumi.threadsafetyagent.util.DoNotTransformException;

public class AddThreadSafetyChecks
extends ClassVisitor {
    private static final String CHECKER_CLASS = "fi/jumi/threadsafetyagent/ThreadSafetyChecker";
    private static final String CHECKER_CLASS_DESC = "Lfi/jumi/threadsafetyagent/ThreadSafetyChecker;";
    private static final String CHECKER_FIELD = "$Jumi$threadSafetyChecker";
    private String myClassName;
    private Label lastGeneratedCode;

    public AddThreadSafetyChecks(ClassVisitor cv) {
        super(262144, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) == 512) {
            throw new DoNotTransformException();
        }
        this.myClassName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (AddThreadSafetyChecks.isConstructor(name)) {
            mv = new InstantiateChecker(this.api, mv);
        } else if (AddThreadSafetyChecks.isInstanceMethod(access)) {
            mv = new CallChecker(this.api, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        this.createCheckerField();
        super.visitEnd();
    }

    private void createCheckerField() {
        FieldVisitor fv = this.visitField(18, CHECKER_FIELD, CHECKER_CLASS_DESC, null, null);
        fv.visitEnd();
    }

    private static boolean isConstructor(String name) {
        return name.equals("<init>");
    }

    private static boolean isInstanceMethod(int access) {
        return (access & 8) == 0;
    }

    private class CallChecker
    extends MethodVisitor {
        public CallChecker(int api, MethodVisitor mv) {
            super(api, mv);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            AddThreadSafetyChecks.this.lastGeneratedCode = new Label();
            super.visitLabel(AddThreadSafetyChecks.this.lastGeneratedCode);
            super.visitVarInsn(25, 0);
            super.visitFieldInsn(180, AddThreadSafetyChecks.this.myClassName, AddThreadSafetyChecks.CHECKER_FIELD, AddThreadSafetyChecks.CHECKER_CLASS_DESC);
            super.visitMethodInsn(182, AddThreadSafetyChecks.CHECKER_CLASS, "checkCurrentThread", "()V");
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            if (AddThreadSafetyChecks.this.lastGeneratedCode != null) {
                super.visitLineNumber(line, AddThreadSafetyChecks.this.lastGeneratedCode);
                AddThreadSafetyChecks.this.lastGeneratedCode = null;
            }
            super.visitLineNumber(line, start);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(Math.max(1, maxStack), maxLocals);
        }
    }

    private class InstantiateChecker
    extends MethodVisitor {
        public InstantiateChecker(int api, MethodVisitor mv) {
            super(api, mv);
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 177) {
                super.visitVarInsn(25, 0);
                super.visitTypeInsn(187, AddThreadSafetyChecks.CHECKER_CLASS);
                super.visitInsn(89);
                super.visitMethodInsn(183, AddThreadSafetyChecks.CHECKER_CLASS, "<init>", "()V");
                super.visitFieldInsn(181, AddThreadSafetyChecks.this.myClassName, AddThreadSafetyChecks.CHECKER_FIELD, AddThreadSafetyChecks.CHECKER_CLASS_DESC);
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(Math.max(3, maxStack), maxLocals);
        }
    }
}

