/*
 * Decompiled with CFR 0.152.
 */
package fi.jasoft.plugin;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class ApplicationServerRunner {
    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        String webAppDir = args[1];
        String classesDir = args[2];
        String logLevel = args[3];
        ArrayList<String> resources = new ArrayList<String>();
        if (new File(webAppDir).exists()) {
            resources.add(webAppDir);
        }
        System.setProperty("org.eclipse.jetty.LEVEL", logLevel);
        Server server = new Server(port);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        WebAppContext handler = new WebAppContext();
        server.setHandler((Handler)handler);
        handler.setContextPath("/");
        handler.setBaseResource((Resource)new ResourceCollection(resources.toArray(new String[resources.size()])));
        handler.setParentLoaderPriority(true);
        handler.setExtraClasspath(classesDir);
        handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/build/classes/.*");
        handler.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration()});
        handler.setClassLoader((ClassLoader)new WebAppClassLoader(ApplicationServerRunner.class.getClassLoader(), (WebAppClassLoader.Context)handler));
        server.start();
        server.join();
    }
}

