/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.VersionCacheProvider;
import com.atlassian.maven.plugins.jgitflow.provider.VersionProvider;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdateCurrentBranchWithHotfixVersionsCommand.class)
public class UpdateCurrentBranchWithHotfixVersionsCommand
implements ExtensionCommand {
    @Requirement
    private VersionCacheProvider versionCacheProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private BranchHelper branchHelper;
    @Requirement
    private VersionProvider versionProvider;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private ContextProvider contextProvider;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand) throws JGitFlowExtensionException {
        try {
            ReleaseContext ctx = this.contextProvider.getContext();
            this.versionCacheProvider.cacheCurrentBranchVersions();
            String currentName = this.branchHelper.getCurrentBranchName();
            List<MavenProject> currentProjects = this.branchHelper.getProjectsForCurrentBranch();
            List<MavenProject> hotfixProjects = this.branchHelper.getProjectsForTopicBranch(BranchType.HOTFIX);
            this.pomUpdater.copyPomVersionsFromProject(hotfixProjects, currentProjects);
            this.projectHelper.commitAllPoms(git, currentProjects, ctx.getScmCommentPrefix() + "Updating " + currentName + " poms to hotfix version to avoid merge conflicts" + ctx.getScmCommentSuffix());
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating current branch poms to hotfix version", (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return ExtensionFailStrategy.ERROR;
    }
}

