/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.jgitflow.api.MavenReleaseFinishExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="release-finish", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ReleaseFinishMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    private boolean allowSnapshots = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(defaultValue="false", property="pushReleases")
    private boolean pushReleases = false;
    @Parameter(defaultValue="false", property="noDeploy")
    private boolean noDeploy = false;
    @Parameter(defaultValue="false", property="keepBranch")
    private boolean keepBranch = false;
    @Parameter(defaultValue="false", property="squash")
    private boolean squash = false;
    @Parameter(defaultValue="false", property="noTag")
    private boolean noTag = false;
    @Parameter(defaultValue="false", property="noReleaseBuild")
    private boolean noReleaseBuild = false;
    @Parameter(defaultValue="false", property="noReleaseMerge")
    private boolean noReleaseMerge = false;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile = true;
    @Parameter(defaultValue="false", property="pullMaster")
    private boolean pullMaster = false;
    @Parameter(defaultValue="false", property="pullDevelop")
    private boolean pullDevelop = false;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(property="tagMessage", defaultValue="")
    private String tagMessage = "";
    @Parameter(property="releaseBranchVersionSuffix", defaultValue="")
    private String releaseBranchVersionSuffix = "";
    @Parameter(defaultValue="")
    private String releaseFinishExtension = "";
    @Component(hint="release")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassloader(this.getClasspath()));
        MavenReleaseFinishExtension extensionObject = (MavenReleaseFinishExtension)this.getExtensionInstance(this.releaseFinishExtension);
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setAutoVersionSubmodules(this.autoVersionSubmodules).setDefaultDevelopmentVersion(this.developmentVersion).setReleaseBranchVersionSuffix(this.releaseBranchVersionSuffix).setPushReleases(this.pushReleases).setKeepBranch(this.keepBranch).setSquash(this.squash).setNoTag(this.noTag).setNoBuild(this.noReleaseBuild).setNoDeploy(this.noDeploy).setUseReleaseProfile(this.useReleaseProfile).setTagMessage(this.tagMessage).setUpdateDependencies(this.updateDependencies).setAllowSnapshots(this.allowSnapshots).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setNoReleaseMerge(this.noReleaseMerge).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setReleaseFinishExtension(extensionObject).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.finish(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error finishing release: " + e.getMessage(), (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }
}

