/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="feature-finish", aggregator=true)
public class FeatureFinishMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="featureName", defaultValue="")
    private String featureName = "";
    @Parameter(defaultValue="false", property="keepBranch")
    private boolean keepBranch = false;
    @Parameter(defaultValue="false", property="squash")
    private boolean squash = false;
    @Parameter(defaultValue="false", property="featureRebase")
    private boolean featureRebase = false;
    @Parameter(defaultValue="false", property="enableFeatureVersions")
    private boolean enableFeatureVersions = false;
    @Parameter(defaultValue="false", property="pushFeatures")
    private boolean pushFeatures = false;
    @Parameter(defaultValue="false", property="noFeatureMerge")
    private boolean noFeatureMerge = false;
    @Parameter(defaultValue="false", property="noFeatureBuild")
    private boolean noFeatureBuild = false;
    @Parameter(defaultValue="false", property="pullMaster")
    private boolean pullMaster = false;
    @Parameter(defaultValue="false", property="pullDevelop")
    private boolean pullDevelop = false;
    @Component(hint="feature")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setNoDeploy(true).setEnableFeatureVersions(this.enableFeatureVersions).setKeepBranch(this.keepBranch).setSquash(this.squash).setFeatureRebase(this.featureRebase).setDefaultFeatureName(this.featureName).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushFeatures(this.pushFeatures).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setNoFeatureMerge(this.noFeatureMerge).setNoBuild(this.noFeatureBuild).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.finish(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error finishing feature: " + e.getMessage(), (Exception)e);
        }
    }
}

