/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.command.HotfixFinishCommand;
import com.atlassian.jgitflow.core.command.HotfixStartCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.extension.HotfixFinishExtension;
import com.atlassian.jgitflow.core.extension.HotfixStartExtension;
import com.atlassian.maven.jgitflow.api.MavenJGitFlowExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.extension.HotfixFinishPluginExtension;
import com.atlassian.maven.plugins.jgitflow.extension.HotfixStartPluginExtension;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractProductionBranchManager;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=FlowReleaseManager.class, hint="hotfix")
public class DefaultFlowHotfixManager
extends AbstractProductionBranchManager {
    @Requirement
    private HotfixStartPluginExtension startExtension;
    @Requirement
    private HotfixFinishPluginExtension finishExtension;

    public DefaultFlowHotfixManager() {
        super(BranchType.HOTFIX);
    }

    @Override
    public void start(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            String hotfixLabel = this.getStartLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            this.startExtension.init((MavenJGitFlowExtension)ctx.getHotfixStartExtension());
            ((HotfixStartCommand)((HotfixStartCommand)((HotfixStartCommand)((HotfixStartCommand)((HotfixStartCommand)flow.hotfixStart(hotfixLabel).setAllowUntracked(ctx.isAllowUntracked())).setPush(ctx.isPushReleases())).setStartCommit(ctx.getStartCommit())).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setExtension((HotfixStartExtension)this.startExtension).call();
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error starting hotfix: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws MavenJGitFlowException {
        JGitFlow flow = null;
        try {
            this.finishExtension.init((MavenJGitFlowExtension)ctx.getHotfixFinishExtension());
            String hotfixLabel = this.getFinishLabelAndRunPreflight(ctx, reactorProjects, session);
            flow = this.jGitFlowProvider.gitFlow();
            this.getLogger().info("running jgitflow hotfix finish...");
            ReleaseMergeResult mergeResult = ((HotfixFinishCommand)((HotfixFinishCommand)((HotfixFinishCommand)((HotfixFinishCommand)((HotfixFinishCommand)flow.hotfixFinish(hotfixLabel).setPush(ctx.isPushReleases())).setKeepBranch(ctx.isKeepBranch())).setNoTag(ctx.isNoTag()).setAllowUntracked(ctx.isAllowUntracked())).setScmMessagePrefix(ctx.getScmCommentPrefix())).setScmMessageSuffix(ctx.getScmCommentSuffix())).setExtension((HotfixFinishExtension)this.finishExtension).call();
            if (!mergeResult.wasSuccessful()) {
                if (mergeResult.masterHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getMasterBranchName() + ":");
                    this.getLogger().error(mergeResult.getMasterResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                if (mergeResult.developHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getDevelopBranchName() + ":");
                    this.getLogger().error(mergeResult.getDevelopResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                throw new MavenJGitFlowException("Error while merging hotfix!");
            }
        }
        catch (JGitFlowException e) {
            throw new MavenJGitFlowException("Error finishing hotfix: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }
}

