/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.command.AbstractBranchMergingCommand;
import com.atlassian.jgitflow.core.command.FeatureRebaseCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.MergeConflictsNotResolvedException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.extension.FeatureFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.EmptyFeatureFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.MergeProcessExtensionWrapper;
import com.atlassian.jgitflow.core.util.FileHelper;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.IterableHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;

public class FeatureFinishCommand
extends AbstractBranchMergingCommand<FeatureFinishCommand, MergeResult> {
    private static final String SHORT_NAME = "feature-finish";
    private boolean rebase;
    private boolean squash;
    private boolean noMerge;
    private FeatureFinishExtension extension;

    public FeatureFinishCommand(String branchName, Git git, GitFlowConfiguration gfConfig) {
        super(branchName, git, gfConfig);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)branchName));
        this.rebase = false;
        this.squash = false;
        this.noMerge = false;
        this.extension = new EmptyFeatureFinishExtension();
    }

    @Override
    public MergeResult call() throws NotInitializedException, JGitFlowGitAPIException, LocalBranchMissingException, JGitFlowIOException, DirtyWorkingTreeException, MergeConflictsNotResolvedException, BranchOutOfDateException, JGitFlowExtensionException, GitAPIException {
        MergeResult mergeResult = this.createEmptyMergeResult();
        String prefixedBranchName = this.runBeforeAndGetPrefixedBranchName(this.extension.before(), JGitFlowConstants.PREFIXES.FEATURE);
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireLocalBranchExists(prefixedBranchName);
        File flowDir = new File(this.git.getRepository().getDirectory(), ".gitflow");
        File mergeBase = new File(flowDir, "MERGE_BASE");
        if (!this.noMerge && mergeBase.exists()) {
            this.reporter.debugText(this.getCommandName(), "restoring from merge conflict. base: " + mergeBase.getAbsolutePath());
            if (GitHelper.workingTreeIsClean(this.git, this.isAllowUntracked()).isClean()) {
                String finishBase = FileHelper.readFirstLine(mergeBase);
                if (GitHelper.isMergedInto(this.git, prefixedBranchName, finishBase)) {
                    mergeBase.delete();
                    this.cleanupBranchesIfNeeded(this.gfConfig.getDevelop(), prefixedBranchName);
                    this.reporter.endCommand();
                    return null;
                }
                mergeBase.delete();
            } else {
                this.reporter.errorText(this.getCommandName(), "Merge conflicts are not resolved");
                this.reporter.endCommand();
                throw new MergeConflictsNotResolvedException("Merge conflicts are not resolved");
            }
        }
        this.enforcer().requireCleanWorkingTree(this.isAllowUntracked());
        try {
            RevCommit developCommit;
            this.doFetchIfNeeded(this.extension);
            this.ensureLocalBranchesNotBehindRemotes(prefixedBranchName, prefixedBranchName, this.gfConfig.getDevelop());
            this.checkoutTopicBranch(prefixedBranchName, this.extension);
            if (this.rebase) {
                this.runExtensionCommands(this.extension.beforeRebase());
                FeatureRebaseCommand rebaseCommand = new FeatureRebaseCommand(this.getBranchName(), this.git, this.gfConfig);
                ((FeatureRebaseCommand)rebaseCommand.setAllowUntracked(this.isAllowUntracked())).call();
                this.runExtensionCommands(this.extension.afterRebase());
            }
            if (!this.noMerge) {
                developCommit = GitHelper.getLatestCommit(this.git, this.gfConfig.getDevelop());
                RevCommit featureCommit = GitHelper.getLatestCommit(this.git, prefixedBranchName);
                List commitList = IterableHelper.asList(this.git.log().setMaxCount(2).addRange((AnyObjectId)developCommit, (AnyObjectId)featureCommit).call());
                MergeProcessExtensionWrapper developExtension = new MergeProcessExtensionWrapper(this.extension.beforeDevelopCheckout(), this.extension.afterDevelopCheckout(), this.extension.beforeDevelopMerge(), this.extension.afterDevelopMerge());
                mergeResult = commitList.size() < 2 ? this.doMerge(prefixedBranchName, this.gfConfig.getDevelop(), developExtension, false, MergeCommand.FastForwardMode.FF) : this.doMerge(prefixedBranchName, this.gfConfig.getDevelop(), developExtension, this.squash);
                if (null == mergeResult || mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.FAILED) || mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
                    FileHelper.createParentDirs(mergeBase);
                    FileUtils.createNewFile((File)mergeBase);
                    FileHelper.writeStringToFile(this.gfConfig.getDevelop(), mergeBase);
                    this.reporter.endCommand();
                    this.reporter.flush();
                    throw new MergeConflictsNotResolvedException("merge conflicts exist, please resolve!");
                }
            }
            this.doPushIfNeeded(this.extension, false, this.gfConfig.getDevelop(), prefixedBranchName);
            this.cleanupBranchesIfNeeded(this.gfConfig.getDevelop(), prefixedBranchName);
            this.reporter.infoText(this.getCommandName(), "checking out '" + this.gfConfig.getDevelop() + "'");
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
            this.reporter.endCommand();
            this.runExtensionCommands(this.extension.after());
            developCommit = mergeResult;
            return developCommit;
        }
        catch (GitAPIException e) {
            this.reporter.endCommand();
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            this.reporter.endCommand();
            throw new JGitFlowIOException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
    }

    public FeatureFinishCommand setRebase(boolean rebase) {
        this.rebase = rebase;
        return this;
    }

    public FeatureFinishCommand setSquash(boolean squash) {
        this.squash = squash;
        return this;
    }

    public FeatureFinishCommand setNoMerge(boolean noMerge) {
        this.noMerge = noMerge;
        return this;
    }

    public FeatureFinishCommand setExtension(FeatureFinishExtension extension) {
        this.extension = extension;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

