/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.command.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.extension.BranchCreatingExtension;
import com.atlassian.jgitflow.core.extension.JGitFlowExtension;
import com.atlassian.jgitflow.core.util.GitHelper;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public abstract class AbstractBranchCreatingCommand<C, T>
extends AbstractGitFlowCommand<C, T> {
    private RevCommit startCommit = null;
    private String startCommitString = null;

    protected AbstractBranchCreatingCommand(String branchName, Git git, GitFlowConfiguration gfConfig) {
        super(branchName, git, gfConfig);
    }

    protected Ref doCreateBranch(String rootBranch, String newBranchName, BranchCreatingExtension extension) throws JGitFlowExtensionException, JGitFlowIOException, LocalBranchMissingException, JGitFlowGitAPIException, BranchOutOfDateException, LocalBranchExistsException, TagExistsException, GitAPIException {
        this.git.checkout().setName(rootBranch).call();
        this.runExtensionCommands(extension.beforeCreateBranch());
        RevCommit startPoint = this.getStartingPoint(rootBranch);
        RevCommit latest = GitHelper.getLatestCommit(this.git, rootBranch);
        this.reporter.debugText(this.getCommandName(), "startPoint is: " + startPoint);
        this.reporter.debugText(this.getCommandName(), "latestCommit is: " + latest.getName());
        if (GitHelper.remoteBranchExists(this.git, rootBranch)) {
            this.enforcer().requireLocalBranchNotBehindRemote(rootBranch);
        }
        this.enforcer().requireCommitOnBranch(startPoint, rootBranch);
        this.enforcer().requireTagAbsent(this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.getBranchName());
        Ref newBranch = this.git.checkout().setName(newBranchName).setCreateBranch(true).setStartPoint(startPoint).call();
        this.reporter.debugText(this.getCommandName(), "created branch: " + newBranchName);
        this.runExtensionCommands(extension.afterCreateBranch());
        return newBranch;
    }

    protected void doPushNewBranchIfNeeded(JGitFlowExtension pushExtension, String branchToPush) throws GitAPIException, JGitFlowGitAPIException, JGitFlowExtensionException, RemoteBranchExistsException, IOException {
        if (this.isPush()) {
            this.enforcer().requireRemoteBranchAbsent(branchToPush);
            this.reporter.infoText(this.getCommandName(), "pushing new branch to origin: " + branchToPush);
            this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(this.gfConfig.getDevelop()), new RefSpec(branchToPush)}).call();
            this.reporter.debugText(this.getCommandName(), "push complete");
            this.git.fetch().setRemote("origin").call();
            StoredConfig config = this.git.getRepository().getConfig();
            config.setString("branch", branchToPush, "remote", "origin");
            config.setString("branch", branchToPush, "merge", "refs/heads/" + branchToPush);
            config.save();
            try {
                config.load();
            }
            catch (ConfigInvalidException e) {
                throw new JGitFlowGitAPIException("unable to load config", e);
            }
            this.runExtensionCommands(pushExtension.afterPush());
        }
    }

    protected RevCommit getStartingPoint(String fromBranch) throws JGitFlowIOException, LocalBranchMissingException {
        RevCommit startPoint = null;
        startPoint = null != this.startCommit ? this.startCommit : (!StringUtils.isEmptyOrNull((String)this.startCommitString) ? GitHelper.getCommitForString(this.git, this.startCommitString) : GitHelper.getLatestCommit(this.git, fromBranch));
        return startPoint;
    }

    public C setStartCommit(String commitId) {
        this.startCommitString = commitId;
        return (C)this;
    }

    public C setStartCommit(RevCommit commit) {
        this.startCommit = commit;
        return (C)this;
    }
}

