/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.ExecutableType;
import eu.toolchain.scribe.InstanceBuilder;
import eu.toolchain.scribe.detector.InstanceBuilderDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class StaticMethodInstanceBuilder
implements InstanceBuilder {
    private final List<EntityField> fields;
    private final Optional<List<String>> fieldNames;
    private final JavaType.Method method;

    public Object newInstance(List<Object> arguments) {
        try {
            return this.method.invoke(null, arguments.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <A extends Annotation> InstanceBuilderDetector forAnnotation(Class<A> marker) {
        return StaticMethodInstanceBuilder.forAnnotation(marker, a -> Optional.empty());
    }

    public static <A extends Annotation> InstanceBuilderDetector forAnnotation(Class<A> marker, Function<A, Optional<List<String>>> names) {
        Annotations.verifyRetentionPolicy(marker, (RetentionPolicy)RetentionPolicy.RUNTIME);
        return (resolver, type) -> type.getMethods().flatMap(m -> {
            if (!m.isPublic() || !m.isStatic()) {
                return Stream.of(new StaticMethodInstanceBuilder[0]);
            }
            return m.getAnnotation(marker).map(a -> {
                List fields = resolver.detectExecutableFields((ExecutableType)m);
                Optional fieldNames = (Optional)names.apply(a);
                if (!type.equals((Object)m.getReturnType())) {
                    throw new IllegalArgumentException(String.format("@%s method must return (%s): %s", marker, type, m));
                }
                fieldNames.ifPresent(n -> {
                    if (n.size() != fields.size()) {
                        throw new IllegalArgumentException("Method (" + m + ") has unexpected number forAnnotation fields (" + fields.size() + "), expected (" + n.size() + ") due to value in " + a + " annotation");
                    }
                });
                return new StaticMethodInstanceBuilder(fields, Optional.empty(), (JavaType.Method)m);
            });
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"fields", "fieldNames", "method"})
    public StaticMethodInstanceBuilder(List<EntityField> fields, Optional<List<String>> fieldNames, JavaType.Method method) {
        this.fields = fields;
        this.fieldNames = fieldNames;
        this.method = method;
    }

    public List<EntityField> getFields() {
        return this.fields;
    }

    public Optional<List<String>> getFieldNames() {
        return this.fieldNames;
    }

    public JavaType.Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticMethodInstanceBuilder)) {
            return false;
        }
        StaticMethodInstanceBuilder other = (StaticMethodInstanceBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EntityField> this$fields = this.getFields();
        List<EntityField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Optional<List<String>> this$fieldNames = this.getFieldNames();
        Optional<List<String>> other$fieldNames = other.getFieldNames();
        if (this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames)) {
            return false;
        }
        JavaType.Method this$method = this.getMethod();
        JavaType.Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public boolean canEqual(Object other) {
        return other instanceof StaticMethodInstanceBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EntityField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        Optional<List<String>> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 0 : ((Object)$fieldNames).hashCode());
        JavaType.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "StaticMethodInstanceBuilder(fields=" + this.getFields() + ", fieldNames=" + this.getFieldNames() + ", method=" + this.getMethod() + ")";
    }
}

