/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;

public class StaticMethodEntityDecodeValueDecoder<Target, Source>
implements Decoder<Target, Source> {
    private final Decoder<Target, Source> parent;
    private final JavaType.Method method;

    public Decoded<Source> decode(Context path, Target instance) {
        return this.parent.decode(path, instance).map(value -> {
            try {
                return this.method.invoke(null, new Object[]{value});
            }
            catch (Exception e) {
                throw path.error("failed to get value", (Throwable)e);
            }
        });
    }

    @ConstructorProperties(value={"parent", "method"})
    public StaticMethodEntityDecodeValueDecoder(Decoder<Target, Source> parent, JavaType.Method method) {
        this.parent = parent;
        this.method = method;
    }

    public Decoder<Target, Source> getParent() {
        return this.parent;
    }

    public JavaType.Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticMethodEntityDecodeValueDecoder)) {
            return false;
        }
        StaticMethodEntityDecodeValueDecoder other = (StaticMethodEntityDecodeValueDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Decoder<Target, Source> this$parent = this.getParent();
        Decoder<Target, Source> other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        JavaType.Method this$method = this.getMethod();
        JavaType.Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public boolean canEqual(Object other) {
        return other instanceof StaticMethodEntityDecodeValueDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Decoder<Target, Source> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 0 : $parent.hashCode());
        JavaType.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "StaticMethodEntityDecodeValueDecoder(parent=" + this.getParent() + ", method=" + this.getMethod() + ")";
    }
}

