/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.DecodeValue;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.StaticMethodEntityDecodeValueDecoder;
import eu.toolchain.scribe.detector.DecodeValueDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StaticMethodEntityDecodeValue
implements DecodeValue {
    private final JavaType sourceType;
    private final Mapping targetMapping;
    private final JavaType.Method method;

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        return this.targetMapping.newDecoder(resolver, Flags.empty(), factory).map(parent -> new StaticMethodEntityDecodeValueDecoder(parent, this.method));
    }

    public static DecodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, sourceType, targetType) -> sourceType.findByAnnotation(JavaType::getMethods, annotation).filter(m -> m.isPublic() && m.isStatic()).filter(m -> m.getParameters().stream().map(JavaType.Parameter::getParameterType).collect(Collectors.toList()).equals(Collections.singletonList(targetType))).flatMap(m -> {
            Mapping targetMapping = resolver.mapping(targetType);
            return Stream.of(new StaticMethodEntityDecodeValue(sourceType, targetMapping, (JavaType.Method)m));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"sourceType", "targetMapping", "method"})
    public StaticMethodEntityDecodeValue(JavaType sourceType, Mapping targetMapping, JavaType.Method method) {
        this.sourceType = sourceType;
        this.targetMapping = targetMapping;
        this.method = method;
    }

    public JavaType getSourceType() {
        return this.sourceType;
    }

    public Mapping getTargetMapping() {
        return this.targetMapping;
    }

    public JavaType.Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticMethodEntityDecodeValue)) {
            return false;
        }
        StaticMethodEntityDecodeValue other = (StaticMethodEntityDecodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$sourceType = this.getSourceType();
        JavaType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Mapping this$targetMapping = this.getTargetMapping();
        Mapping other$targetMapping = other.getTargetMapping();
        if (this$targetMapping == null ? other$targetMapping != null : !this$targetMapping.equals(other$targetMapping)) {
            return false;
        }
        JavaType.Method this$method = this.getMethod();
        JavaType.Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public boolean canEqual(Object other) {
        return other instanceof StaticMethodEntityDecodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 0 : $sourceType.hashCode());
        Mapping $targetMapping = this.getTargetMapping();
        result = result * 59 + ($targetMapping == null ? 0 : $targetMapping.hashCode());
        JavaType.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "StaticMethodEntityDecodeValue(sourceType=" + this.getSourceType() + ", targetMapping=" + this.getTargetMapping() + ", method=" + this.getMethod() + ")";
    }
}

