/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.EntityFieldStreamEncoder;
import eu.toolchain.scribe.EntityFieldsStreamEncoder;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.StreamEncoderFactory;
import java.beans.ConstructorProperties;
import java.util.List;

public class ReadFieldsEntityStreamEncoder<Target>
implements EntityStreamEncoder<Target, Object> {
    private final List<ReadFieldsEntityField<Target, Object>> fields;
    private final StreamEncoderFactory<Target> factory;

    public void streamEncode(EntityFieldsStreamEncoder<Target> encoder, Context path, Object instance, Target target, Runnable callback) {
        encoder.encodeStart(target);
        callback.run();
        for (ReadFieldsEntityField<Target, Object> m : this.fields) {
            Object value;
            EntityFieldStreamEncoder<Target, Object> fieldEncoder = m.getEncoder();
            FieldReader reader = m.getReader();
            Context p = path.push(fieldEncoder.getName());
            try {
                value = reader.read(instance);
            }
            catch (Exception e) {
                throw p.error("failed to read value", (Throwable)e);
            }
            if (value == null) {
                throw p.error("null value read");
            }
            try {
                encoder.encodeField(fieldEncoder, p, value, target);
            }
            catch (Exception e) {
                throw p.error("failed to encode", (Throwable)e);
            }
        }
        encoder.encodeEnd(target);
    }

    public void streamEncode(Context path, Object instance, Target target) {
        this.streamEncode(this.factory.newEntityStreamEncoder(), path, instance, target, EntityStreamEncoder.EMPTY_CALLBACK);
    }

    public void streamEncodeEmpty(Context path, Target target) {
        this.factory.newEntityStreamEncoder().encodeEmpty(path, target);
    }

    @ConstructorProperties(value={"fields", "factory"})
    public ReadFieldsEntityStreamEncoder(List<ReadFieldsEntityField<Target, Object>> fields, StreamEncoderFactory<Target> factory) {
        this.fields = fields;
        this.factory = factory;
    }

    public List<ReadFieldsEntityField<Target, Object>> getFields() {
        return this.fields;
    }

    public StreamEncoderFactory<Target> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadFieldsEntityStreamEncoder)) {
            return false;
        }
        ReadFieldsEntityStreamEncoder other = (ReadFieldsEntityStreamEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ReadFieldsEntityField<Target, Object>> this$fields = this.getFields();
        List<ReadFieldsEntityField<Target, Object>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        StreamEncoderFactory<Target> this$factory = this.getFactory();
        StreamEncoderFactory<Target> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public boolean canEqual(Object other) {
        return other instanceof ReadFieldsEntityStreamEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ReadFieldsEntityField<Target, Object>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        StreamEncoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "ReadFieldsEntityStreamEncoder(fields=" + this.getFields() + ", factory=" + this.getFactory() + ")";
    }

    public static class ReadFieldsEntityField<Target, Source> {
        private final EntityFieldStreamEncoder<Target, Source> encoder;
        private final FieldReader reader;

        @ConstructorProperties(value={"encoder", "reader"})
        public ReadFieldsEntityField(EntityFieldStreamEncoder<Target, Source> encoder, FieldReader reader) {
            this.encoder = encoder;
            this.reader = reader;
        }

        public EntityFieldStreamEncoder<Target, Source> getEncoder() {
            return this.encoder;
        }

        public FieldReader getReader() {
            return this.reader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadFieldsEntityField)) {
                return false;
            }
            ReadFieldsEntityField other = (ReadFieldsEntityField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EntityFieldStreamEncoder<Target, Source> this$encoder = this.getEncoder();
            EntityFieldStreamEncoder<Target, Source> other$encoder = other.getEncoder();
            if (this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder)) {
                return false;
            }
            FieldReader this$reader = this.getReader();
            FieldReader other$reader = other.getReader();
            return !(this$reader == null ? other$reader != null : !this$reader.equals(other$reader));
        }

        public boolean canEqual(Object other) {
            return other instanceof ReadFieldsEntityField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntityFieldStreamEncoder<Target, Source> $encoder = this.getEncoder();
            result = result * 59 + ($encoder == null ? 0 : $encoder.hashCode());
            FieldReader $reader = this.getReader();
            result = result * 59 + ($reader == null ? 0 : $reader.hashCode());
            return result;
        }

        public String toString() {
            return "ReadFieldsEntityStreamEncoder.ReadFieldsEntityField(encoder=" + this.getEncoder() + ", reader=" + this.getReader() + ")";
        }
    }
}

