/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityFieldEncoder;
import eu.toolchain.scribe.EntityFieldsEncoder;
import eu.toolchain.scribe.FieldReader;
import java.beans.ConstructorProperties;
import java.util.List;

public class ReadFieldsEntityEncoder<Target>
implements EntityEncoder<Target, Object> {
    private final List<? extends Field<Target, Object>> fields;
    private final EncoderFactory<Target> factory;

    public Target encode(EntityFieldsEncoder<Target> encoder, Context path, Object instance, Runnable callback) {
        callback.run();
        for (Field<Target, Object> m : this.fields) {
            Object value;
            EntityFieldEncoder<Target, Object> fieldEncoder = m.getEncoder();
            FieldReader reader = m.getReader();
            Context p = path.push(fieldEncoder.getName());
            try {
                value = reader.read(instance);
            }
            catch (Exception e) {
                throw p.error("Failed to read value using " + reader, (Throwable)e);
            }
            if (value == null) {
                throw p.error("Null value read from " + reader);
            }
            try {
                encoder.encodeField(fieldEncoder, p, value);
            }
            catch (Exception e) {
                throw p.error("Failed to encode field", (Throwable)e);
            }
        }
        return (Target)encoder.build();
    }

    public Target encode(Context path, Object instance) {
        return this.encode(this.factory.newEntityEncoder(), path, instance, EntityEncoder.EMPTY_CALLBACK);
    }

    public Target encodeEmpty(Context path) {
        return (Target)this.factory.newEntityEncoder().buildEmpty(path);
    }

    @ConstructorProperties(value={"fields", "factory"})
    public ReadFieldsEntityEncoder(List<? extends Field<Target, Object>> fields, EncoderFactory<Target> factory) {
        this.fields = fields;
        this.factory = factory;
    }

    public List<? extends Field<Target, Object>> getFields() {
        return this.fields;
    }

    public EncoderFactory<Target> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadFieldsEntityEncoder)) {
            return false;
        }
        ReadFieldsEntityEncoder other = (ReadFieldsEntityEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Field<Target, Object>> this$fields = this.getFields();
        List<Field<Target, Object>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        EncoderFactory<Target> this$factory = this.getFactory();
        EncoderFactory<Target> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public boolean canEqual(Object other) {
        return other instanceof ReadFieldsEntityEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Field<Target, Object>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        EncoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "ReadFieldsEntityEncoder(fields=" + this.getFields() + ", factory=" + this.getFactory() + ")";
    }

    public static class Field<Target, Source> {
        private final EntityFieldEncoder<Target, Source> encoder;
        private final FieldReader reader;

        @ConstructorProperties(value={"encoder", "reader"})
        public Field(EntityFieldEncoder<Target, Source> encoder, FieldReader reader) {
            this.encoder = encoder;
            this.reader = reader;
        }

        public EntityFieldEncoder<Target, Source> getEncoder() {
            return this.encoder;
        }

        public FieldReader getReader() {
            return this.reader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EntityFieldEncoder<Target, Source> this$encoder = this.getEncoder();
            EntityFieldEncoder<Target, Source> other$encoder = other.getEncoder();
            if (this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder)) {
                return false;
            }
            FieldReader this$reader = this.getReader();
            FieldReader other$reader = other.getReader();
            return !(this$reader == null ? other$reader != null : !this$reader.equals(other$reader));
        }

        public boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntityFieldEncoder<Target, Source> $encoder = this.getEncoder();
            result = result * 59 + ($encoder == null ? 0 : $encoder.hashCode());
            FieldReader $reader = this.getReader();
            result = result * 59 + ($reader == null ? 0 : $reader.hashCode());
            return result;
        }

        public String toString() {
            return "ReadFieldsEntityEncoder.Field(encoder=" + this.getEncoder() + ", reader=" + this.getReader() + ")";
        }
    }
}

